/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
/*
segatex written by Shintaro Fujiwara.
This code is dedicated to my daughter, mone.
*/
/*uninstd.h should be the first.*/
#include <unistd.h>
#include <stdio.h>
#include <time.h>

#include <iostream>
#include <fstream>
#include <string.h>
#include <vector>
#include <algorithm>
#include <map>
#include <boost/regex.hpp>
#include <qfile.h>
/*for segate_show_status()*/
#include <selinux/selinux.h>
#include <selinux/get_default_type.h>
/*for segatex_show_ps()*/
#include <stdlib.h>
/*for segatex_solve_problem()*/
#include <sys/io.h>
//#include <fcntl.h>
//#include <sys/stat.h>
//#include <sys/types.h>
#include <boost/tokenizer.hpp>

/*These should be globals.*/

int log_state = 0;
time_t the_time;
long log_from_time = 0;
int log_from_time_int = 0;

#define MAX_LOG 8460

/*prototype declaration*/
int segatex_set_time_real();
int segatex_set_time_all_real();
void segatex_set_time();
void segatex_set_time_all();
void segatex_show_denied();
void segatex_show_allowed();
void segatex_show_sestatus();
void segatex_show_interface();
void segatex_show_ps();


void segatex::segatex_show_denied()
{
	using namespace std;
	using namespace boost;

	const char* filename="/var/log/audit/audit.log";
        const char* filename_denied_all="./segatex_audit_denied.log_all";
        const char* filename_denied="./segatex_audit_denied.log";

	if(log_state == 0){
		log_from_time_int = segatex::segatex_set_time_all_real(); 
	}
	else if(log_state == 1){
		log_from_time_int = segatex::segatex_set_time_real();
	}

        ifstream is;
        char buffer_c[MAX_LOG];
	is.open(filename);
        if(!is.getline(buffer_c, sizeof buffer_c)){
                cout << "no-data" << endl;
                is.close();
        }
        if(is)
        {
                vector<string> v2;
                vector<string>::iterator p2, p2_end;

                ofstream os;
                os.open(filename_denied_all);
                ofstream os_policy;
                os_policy.open(filename_denied);
                if((os_policy)&&(os))
                {
                        char buffer[MAX_LOG];
                        const char* words="denied";
                        vector<string> v;
                        vector<string>::iterator p, p_end;

                        while(is.getline(buffer, sizeof buffer))
                        {
                                if(strstr(buffer,words)){
                                        os << buffer << endl;
                                       	v.push_back(buffer);
                                }
                                if(!os)
                                        break;
                        }
                        os.close();

                        const char* den = "denied";
                        const char* log_time = "audit\\([0-9]{10}";
                        regex denied_exp(den);
                        regex log_time_exp(log_time);

                        string log_time_string = "";
                        int log_time_int = 0;

                        for(p=v.begin(); p<v.end();p++){
                                string source_ready = *p;
                                const char* source = source_ready.c_str();
                                cmatch what;
                                if(regex_search(source,what,denied_exp)){
                                        if(regex_search(source,what,log_time_exp)){
                                                log_time_string = what[0];
                                                log_time_string = log_time_string.substr(6);
                                                log_time_int = atoi(log_time_string.c_str());
                                        }
					if(log_from_time_int <= log_time_int){
                                        	v2.push_back(source_ready.c_str());
					}
                                }
                        }
                        sort(v2.begin(),v2.end());
                        p2_end = unique(v2.begin(),v2.end());
                        for(p2=v2.begin();p2<p2_end;p2++){
		    os_policy << *p2 << endl;
	          }
                is.close();
                os_policy.close();
                }
		QFile file( filename_denied); // Read the text from a file
                if ( file.open( IO_ReadOnly ) ) {
			QTextStream stream( &file );
			textEdit1->setText( stream.read() );
		}
        }
}


void segatex::segatex_show_allowed()
{
	using namespace std;
	using namespace boost;

	const char* filename="/var/log/audit/audit.log";
        const char* filename_allow_all="./segatex_audit_allowed.log_all";
        const char* filename_allow="./segatex_audit_allow.log";

	if(log_state == 0){
		log_from_time_int = segatex::segatex_set_time_all_real(); 
	}
	else if(log_state == 1){
		log_from_time_int = segatex::segatex_set_time_real();
	}

        ifstream is;
        char buffer_c[MAX_LOG];
        is.open(filename);
        if(!is.getline(buffer_c, sizeof buffer_c)){
                cout << "no-data" << endl;
                is.close();
        }
        if(is)
        {
                vector<string> v2;
                vector<string>::iterator p2, p2_end;

                ofstream os;
                os.open(filename_allow_all);
                ofstream os_policy;
                os_policy.open(filename_allow);
                if((os_policy)&&(os))
                {
                        char buffer[MAX_LOG];
                        const char* words="denied";
                        vector<string> v;
                        vector<string>::iterator p, p_end;

                        while(is.getline(buffer, sizeof buffer))
                        {
                                if(!strstr(buffer,words)){
                                        os << buffer << endl;
                                        v.push_back(buffer);
                                }
                                if(!os)
                                        break;
                        }
                        os.close();
                        const char* den = "denied";
                        const char* log_time = "audit\\([0-9]{10}";
                        regex denied_exp(den);
                        regex log_time_exp(log_time);

                        string log_time_string = "";
                        int log_time_int = 0;

                        for(p=v.begin(); p<v.end();p++){
                                string source_ready = *p;
                                const char* source = source_ready.c_str();
                                cmatch what;
                                if(!regex_search(source,what,denied_exp)){
                                        if(regex_search(source,what,log_time_exp)){
                                                log_time_string = what[0];
                                                log_time_string = log_time_string.substr(6);
                                                log_time_int = atoi(log_time_string.c_str());
                                        }
					if(log_from_time_int <= log_time_int){
                                        	v2.push_back(source_ready.c_str());
					}
                                }
                        }
                        sort(v2.begin(),v2.end());
                        p2_end = unique(v2.begin(),v2.end());
                        for(p2=v2.begin();p2<p2_end;p2++){
				os_policy << *p2 << endl;
			}
			is.close();
			os_policy.close();
		}
		QFile file( filename_allow); // Read the text from a file
		if ( file.open( IO_ReadOnly ) ) {
			QTextStream stream( &file );
			textEdit1->setText( stream.read() );
		}
	}
}


int segatex::segatex_set_time_real()
{
        log_from_time = time((time_t*)0);
        log_from_time_int = (int)log_from_time;
        log_from_time_int = log_from_time_int - 60*30;
        return log_from_time_int;
}
int segatex::segatex_set_time_all_real()
{
        log_from_time_int = 0;
        return log_from_time_int;
}
void segatex::segatex_set_time()
{
	log_state = 1;
}

void segatex::segatex_set_time_all()
{
	log_state = 0;
}

void segatex::segatex_show_interface()
{
	/*ŪɽΰʤƤʤᡢ©ʼʤȤäƶϫƤ...*/

	using namespace std;
	using namespace boost;
	const char* filename="/var/log/audit/audit.log";
        const char* filename_new="./segatex_audit_denied.log";
        const char* filename_policy="./my_policy_by_segatex.te";
	if(log_state == 0){
		log_from_time_int = segatex::segatex_set_time_all_real(); 
	}
	else if(log_state == 1){
		log_from_time_int = segatex::segatex_set_time_real();
	}
	char buffer_engine[MAX_LOG];
        char buffer_c[MAX_LOG];

	//read from engine and store them to v_engine
        const char* filename_engine="./selpaw_interface.csv";

        ifstream is_engine;
        is_engine.open(filename_engine);
        if(!is_engine.getline(buffer_engine, sizeof buffer_engine)){
                cout << "selpaw_interface.csv is missing!!" << endl;
                is_engine.close();
        }
        if(is_engine)
        {
		vector<string> v_engine;
		vector<string>::iterator p_engine, p_engine_end;
		while(is_engine.getline(buffer_engine, sizeof buffer_engine)){
			v_engine.push_back(buffer_engine);
		}
		//open log
		ifstream is;
		is.open(filename);
		if(!is.getline(buffer_c, sizeof buffer_c)){
			cout << "no-data" << endl;
			is.close();
		}
		if(is)
		{
			vector<string> v2;
			vector<string>::iterator p2_v, p2_v_end;
			multimap<string ,string>::iterator p2,p2_end;
			multimap<string ,string>::iterator p2_m,p2_m_end;
			ofstream os;
			os.open(filename_new);
			ofstream os_policy;
			os_policy.open(filename_policy);
			if((os_policy)&&(os))
			{
				char buffer[MAX_LOG];
				const char* words="denied";
				vector<string> v;
				vector<string>::iterator p, p_end;
				while(is.getline(buffer, sizeof buffer))
				{
					if(strstr(buffer,words)){
						os << buffer << endl;
						v.push_back(buffer);
					}
					if(!os)
					break;
				}
				os.close();
	//FC5Υη
	//type=AVC msg=audit(1152547592.021:9): avc:  denied  { tcp_send } for  pid=1638 comm="httpd" saddr=0000:0000:0000:0000:0000:0000:0000:0001 src=42207 daddr=0000:0000:0000:0000:0000:0000:0000:0001 dest=443 netif=lo scontext=system_u:system_r:httpd_t:s0 tcontext=system_u:object_r:compat_ipv4_node_t:s0 tclass=node

				const char* den = "denied";
				const char* log_time = "audit\\([0-9]{10}";
				const char* scontext = "scontext([^[:blank:]]*)([:blank:])?";
				const char* scontext_rev = "t_[a-z0-9_]([^:]*)?";
				const char* tcontext = "tcontext([^[:blank:]]*)([:blank:])?";
				const char* tcontext_rev = "t_[a-z0-9_]([^:]*)?";
				const char* tclass = "tclass(.*)";
				const char* tclass_2 = "[a-z0-9_]([^=]*)?";
				const char* acc = "\\{(.*)\\}";
				regex denied_exp(den);
				regex log_time_exp(log_time);
				regex domain_exp(scontext);
				regex domain_rev_exp(scontext_rev);
				regex resource_exp(tcontext);
				regex resource_rev_exp(tcontext_rev);
				regex object_class_exp(tclass);
				regex object_class_exp_2(tclass_2);
				regex access_vector_exp(acc);

				string log_time_string = "";
				int log_time_int = 0;
				string policy_selinux = "";
				string allow_pre = "allow";
				string blank_w = " ";
				string colon = ":";
				string semicolon = ";";
				string domain = "";
				string domain_2 = "";
				string resource = "";
				string resource_2 = "";
				string object_class_pre = "";
				string object_class = "";
				string access_vector = "";
				//multimap<string, string>macro_pre;
				multimap<string, string> pattern_matched;
				multimap<string, string>::iterator p_pattern_matched;

				multimap<string, string> pattern_not_matched;
				multimap<string, string>::iterator p_pattern_not_matched;
	/*
				multimap<string, string> pattern_matched_objclass;
				multimap<string, string>::iterator p_pattern_matched_objclass;
	*/
				multimap<string, string> pattern_matched_access_vector;
				multimap<string, string>::iterator p_pattern_matched_access_vector;
	/*
				multimap<string, string> pattern_matched_domain;
				multimap<string, string>::iterator p_pattern_matched_domain;
				multimap<string, string> pattern_matched_tclass;
				multimap<string, string>::iterator p_pattern_matched_tclass;
	*/
	//̾ϡnot_matchedˤʤäƤ뤬Ƥξ֤ޥޥåפɬפȤ߹碌Ƥ*/
				multimap<string, string> pattern_not_matched_objclass;
				multimap<string, string>::iterator p_pattern_not_matched_objclass;
				multimap<string, string> pattern_not_matched_access_vector;
				multimap<string, string>::iterator p_pattern_not_matched_access_vector;
				multimap<string, string> pattern_not_matched_domain;
				multimap<string, string>::iterator p_pattern_not_matched_domain;
				multimap<string, string> pattern_not_matched_tclass;
				multimap<string, string>::iterator p_pattern_not_matched_tclass;
				multimap<string, string> pattern_allow_not_matched_echo;
				multimap<string, string>::iterator p_pattern_allow_not_matched_echo;
				multimap<string, string> pattern_matched_tclassobjclass_interface;
				multimap<string, string>::iterator p_pattern_matched_tclassobjclass_interface;

				vector<string> v_source_interface_pre;
				vector<string>::iterator p_source_interface_pre, p_source_interface_pre_end;

				vector<string> v_matched_tmp_objclass;
				vector<string>::iterator p_matched_tmp_objclass, p_matched_tmp_objclass_end;
				vector<string> v_matched_objclass_accv;
				vector<string>::iterator p_matched_objclass_accv, p_matched_objclass_accv_end;
				vector<string> v_matched_tmp_domain;
				vector<string>::iterator p_matched_tmp_domain, p_matched_tmp_domain_end;

				vector<string> v_tmp_objclass;
				vector<string>::iterator p_tmp_objclass, p_tmp_objclass_end;
				vector<string> v_accv;
				vector<string>::iterator p_accv, p_accv_end;
				vector<string> v_tmp_domain;
				vector<string>::iterator p_tmp_domain, p_tmp_domain_end;


				vector<string> v_allow_first;
				vector<string>::iterator p_allow_first, p_allow_first_end;
				vector<string> v_allow_last;
				vector<string>::iterator p_allow_last, p_allow_last_end;
				vector<string> v_domain_interface;
				vector<string>::iterator p_domain_interface, p_domain_interface_end;

				vector<string> v_interface_raw;
				vector<string>::iterator p_interface_raw, p_interface_raw_end;

				for(p=v.begin(); p<v.end();p++){
					string source_ready = *p;
					const char* source = source_ready.c_str();
					cmatch what;
					if(regex_search(source,what,denied_exp)){
						if(regex_search(source,what,domain_exp)){
							domain = what[0];
							int str_length = strlen(domain.c_str());
							int i=str_length;
							string str_rev="";
							string str_rev_all="";
							for(i=str_length;i>0;i--){
								str_rev = domain.substr(i,1);
								str_rev_all = str_rev_all + str_rev;
							}
							const char* str_rev_all_char = str_rev_all.c_str();
							if(regex_search(str_rev_all_char,what,domain_rev_exp)){
								domain_2 = what[0];
								int str_length = strlen(domain_2.c_str());
								int i=str_length;
								string str_rev="";
								string str_rev_all="";
								for(i=str_length;i>=0;i--){
									str_rev = domain_2.substr(i,1);
									str_rev_all = str_rev_all + str_rev;
								}
								domain = str_rev_all;
							}
						}
						if(regex_search(source,what,resource_exp)){
							resource = what[0];
							int str_length = strlen(resource.c_str());
							int i=str_length;
							string str_rev="";
							string str_rev_all="";
							for(i=str_length;i>0;i--){
								str_rev = resource.substr(i,1);
								str_rev_all = str_rev_all + str_rev;
							}
							const char* str_rev_all_char = str_rev_all.c_str();
							if(regex_search(str_rev_all_char,what,resource_rev_exp)){
								resource_2 = what[0];
								int str_length = strlen(resource_2.c_str());
								int i=str_length;
								string str_rev="";
								string str_rev_all="";
								for(i=str_length;i>=0;i--){
									str_rev = resource_2.substr(i,1);
									str_rev_all = str_rev_all + str_rev;
								}
								resource = str_rev_all;
							}
						}
						if(regex_search(source,what,object_class_exp)){
							object_class_pre = what[0];
							int str_length = strlen(object_class_pre.c_str());
							int i=str_length;
							string str_rev="";
							string str_rev_all="";
							for(i=str_length;i>0;i--){
								str_rev = object_class_pre.substr(i,1);
								str_rev_all = str_rev_all + str_rev;
							}
							const char* str_rev_all_char = str_rev_all.c_str();
							if(regex_search(str_rev_all_char,what,object_class_exp_2)){
								object_class = what[0];
								int str_length = strlen(object_class.c_str());
								int i=str_length;
								string str_rev="";
								string str_rev_all="";
								for(i=str_length;i>=0;i--){
									str_rev = object_class.substr(i,1);
									str_rev_all = str_rev_all + str_rev;
								}
								object_class = str_rev_all;
							}
						}
						if(regex_search(source,what,access_vector_exp)){
							access_vector = what[0];
						}
						policy_selinux = allow_pre + blank_w +
							domain + blank_w + resource + colon + object_class + blank_w + access_vector;
						if(regex_search(source,what,log_time_exp)){
							log_time_string = what[0];
							log_time_string = log_time_string.substr(6);
							log_time_int = atoi(log_time_string.c_str());
						}
						if(log_from_time_int <= log_time_int){
							v2.push_back(policy_selinux.c_str());
						}
					  }
				}
				sort(v2.begin(),v2.end());
				p2_v_end = unique(v2.begin(),v2.end());
				const char* m_pre = "(.*):([^[:space:]]*)([:space:])?";
				const char* m_interface_pre = "[a-z]([^[:space:]]*):([^[:space:]]*)([:space:])?";
				const char* m_domain_pre = "[a-z0-9_]*_t";
				const char* m_tclass_pre = "[a-z0-9_]*_t:";
				const char* m_objclass_pre = ":[a-z0-9_]*";
				const char* m_acc = "\\{(.*)\\}";
				const char* m_blank = "[a-z0-9_](.*)[a-z0-9_]";
				regex m_pre_exp(m_pre);
				regex m_interface_pre_exp(m_interface_pre);
				regex m_domain_pre_exp(m_domain_pre);
				regex m_tclass_pre_exp(m_tclass_pre);
				regex m_objclass_pre_exp(m_objclass_pre);
				regex m_access_vector_exp(m_acc);
				regex m_blank_exp(m_blank);
				string source_macro_pre="";
				string source_interface_pre="";
				string source_domain_pre="";
				string source_tclass_pre="";
				string source_objclass_pre="";
				string source_access_vector_pre="";
				string source_interface_pre_prev="";
				string source_interface_engine="";
				string access_vector_m = "";
				string blank_m = "";

				int source_macro_numbers=0;
				for(p2_v=v2.begin(); p2_v < v2.end(); p2_v++){
					string source_macro = *p2_v;

					/*for debug*/
					//ޥʸ
					//os_policy << source_macro << endl;
					/*end for debug*/
					const char* source_m = source_macro.c_str();
					cmatch what;
					if(regex_search(source_m,what,m_domain_pre_exp)){
						source_domain_pre  = what[0];
						/*for debug*/
					//	os_policy << source_domain_pre << endl;	
					} 
					if(regex_search(source_m,what,m_tclass_pre_exp)){
						source_tclass_pre  = what[0];
						int length=strlen(source_tclass_pre.c_str());
						string blank_str="";
						source_tclass_pre=source_tclass_pre.replace(length - 1,1,blank_str);
						/*for debug*/
						//os_policy << source_tclass_pre << endl;	
					} 
					if(regex_search(source_m,what,m_objclass_pre_exp)){
						source_objclass_pre  = what[0];
						string blank_str="";
						source_objclass_pre=source_objclass_pre.replace(0,1,blank_str);
						/*for debug*/
					//	os_policy << source_objclass_pre << endl;	
					} 
					if(regex_search(source_m,what,m_access_vector_exp)){
						source_access_vector_pre  = what[0];
						int length=strlen(source_access_vector_pre.c_str());
						string blank_str="";
						source_access_vector_pre=source_access_vector_pre.replace(length - 2,2,blank_str);
						source_access_vector_pre=source_access_vector_pre.replace(0,2,blank_str);
						/*for debug*/
						//os_policy << source_access_vector_pre << endl;	
					} 
					if(regex_search(source_m,what,m_interface_pre_exp)){
						source_interface_pre  = what[0];
						/*for debug*/
				//		os_policy << source_interface_pre << endl;	
						/*end for debug*/
						//ok,ǡhttpd_t:file Ǥ
						if(source_interface_pre != source_interface_pre_prev){
							v_source_interface_pre.push_back(source_interface_pre.c_str());
							source_interface_pre_prev  = what[0];
						}
					} 
					/*ޥåΤޤᡢmultimapɤ߹ǤǼФ򤹤*/
					pattern_matched.insert(pair<string, string>(source_interface_pre,source_domain_pre));
					pattern_not_matched.insert(pair<string, string>(source_interface_pre,source_macro));
					pattern_not_matched_objclass.insert(pair<string, string>(source_interface_pre,source_objclass_pre));
					pattern_not_matched_access_vector.insert(pair<string, string>(source_objclass_pre,source_access_vector_pre));
					pattern_not_matched_domain.insert(pair<string, string>(source_interface_pre,source_domain_pre));
					pattern_not_matched_tclass.insert(pair<string, string>(source_interface_pre,source_tclass_pre));
					source_macro_numbers++;
				}
				int interface_numbers=0;
				//string was_not_matched = " was not matched !";
				string source_interface_pre_comp="";
				for(p_source_interface_pre=v_source_interface_pre.begin(); p_source_interface_pre < v_source_interface_pre.end(); p_source_interface_pre++){
					//ʸϡsource_interface_pre ʤ㡧httpd_t:file
					string source_interface_pre = *p_source_interface_pre;
					//const char* m_interface_accv = ":(.*)\\{(.*)\\}";
					const char* m_interface_accv_pre = ":(.*)\\}";
					const char* m_interface_accv = "(:[a-z0-9_]*)[[:space:]]";
					regex m_interface_accv_exp(m_interface_accv);
					regex m_interface_accv_pre_exp(m_interface_accv_pre);
					string source_interface_accv_pre;
					string source_interface_accv;

					cmatch what;
					string plus_1 = "(?:";
					regex re("[a-z0-9_]*,");
					string plus_3 = ")";
					string plus_source_interface_pre = plus_1 + source_interface_pre + plus_3;
					const char* m_engine = plus_source_interface_pre.c_str();
					regex m_interface_engine_exp(m_engine);
					/*read the engine and check*/
					/*󥸥ե夫鸡롣forפСޥåƤ*/
					for(p_engine=v_engine.begin(); p_engine < v_engine.end(); p_engine++){
						string source_macro_engine = *p_engine;
						const char* source_m_engine = source_macro_engine.c_str();
						if(regex_search(source_m_engine,what,m_interface_engine_exp)){
							source_interface_engine  = what[0];
							//os_policy << source_interface_pre ;
							//os_policy << " matched !!" << endl;
							/*interface all sentence*/
							//os_policy << source_macro_engine << endl;
							/*end interface all sentence*/
							/*Ǥϡޥå祤󥿥եobjectclassΥ٥ޥޥåפѤ*/
							if(regex_search(source_m_engine,what,m_interface_accv_pre_exp)){
								source_interface_accv_pre  = what[0];
								const char* source_interface_accv_pre_str = source_interface_accv_pre.c_str();
								//os_policy << source_interface_accv_pre << endl;
								if(regex_search(source_interface_accv_pre_str,what,m_interface_accv_exp)){
									source_interface_accv  = what[0];
									int length=strlen(source_interface_accv.c_str());
									string blank_str="";
									source_interface_accv=source_interface_accv.replace(length,1,blank_str);
									source_interface_accv=source_interface_accv.replace(0,1,blank_str);
									//os_policy << source_interface_accv << endl;
									//v_matched_objclass_accv.push_back(source_interface_accv.c_str());
								}
								int length=strlen(source_interface_accv_pre.c_str());
								string blank_str="";
								string bracket_first_str="{";
								source_interface_accv_pre=source_interface_accv_pre.replace(length -1,1,blank_str);
								int bracket_first_position=source_interface_accv_pre.find_first_of(bracket_first_str);
								source_interface_accv_pre=source_interface_accv_pre.replace(0,bracket_first_position + 1,blank_str);
								//os_policy << source_interface_accv_pre << endl;
								regex tmp_re("[[:space:]]([^[:space:]]*)[a-z0-9_]*");
								string::const_iterator it=source_interface_accv_pre.begin(), end=source_interface_accv_pre.end();
								while(it != end){
									smatch result;
									if( !regex_search(it, end, result, tmp_re)){
										break;
									}
									//os_policy << "interface_core<" << source_interface_accv << ":" << result.str() << ">" << endl;
									pattern_matched_access_vector.insert(pair<string, string>(source_interface_accv,result.str()));
									it = result[0].second;
								}
							}
							/*󥿥եλobjectclassΥ٥ѤߤϤޤ*/
							if(regex_search( source_macro_engine, re )){
								string::const_iterator it=source_macro_engine.begin(), end=source_macro_engine.end();
								int i=0;
								string check_str = ":";
								string bracket_first_str = "(";
								string bracket_last_str = ")";
								while( it != end){
									//ޥåսƬ
									smatch result;
									if( !regex_search(it, end, result, re)){
										break;
									}
									//os_policy << result.str() << endl;
									it = result[0].second;
									if(i==2){
										//ǡhttpd_t:file multimap餵ơdomainѴmatchedΥ٥ѤȤǤꡣ
										//Ȥä顢interfaceϤäȹΤǡinterfaceȤ٥Ѥǡ⤦󥨥󥸥ˤobjectclass,access_vectorФɬפä
										int length=strlen(result.str().c_str());
										string blank_str="";
										string interface_raw_str=result.str().replace(length -1,1,blank_str);
										v_interface_raw.push_back(interface_raw_str.c_str());
										//os_policy << interface_raw_str << endl;
										p_pattern_not_matched_domain=pattern_not_matched_domain.find(source_interface_pre);
										if(p_pattern_not_matched_domain != pattern_not_matched_domain.end()){
											do{
												int length=strlen(result.str().c_str());
												string blank_str="";
												string result_str=result.str().replace(length -1,1,blank_str);
												
												//string domain_interface_echo = result.str() + bracket_first_str + p_pattern_not_matched_domain->second + bracket_last_str;  
												string domain_interface_echo = result_str + bracket_first_str + p_pattern_not_matched_domain->second + bracket_last_str;  
												v_domain_interface.push_back(domain_interface_echo.c_str());
												//os_policy << result.str() << "(" << p_pattern_not_matched_domain->second << ")" << endl;
												p_pattern_not_matched_domain++;
											}while(p_pattern_not_matched_domain != pattern_not_matched_domain.upper_bound(source_interface_pre));
										}
										//pattern_matched_tclassobjclass_interface.insert(pair<string, string>(source_interface_pre,result.str()));
									}
									//os_policy << i << endl;
									i++;
								}
								interface_numbers++;
					//			os_policy << interface_numbers << endl;
							}
						}
						/*ޥåȤobjclass typeФˡ롣*/
						/*ǤޤȤơ٥ƥʤѤǤ夫饽ȥˡƽФ*/
						if(source_interface_pre_comp != source_interface_pre){
							p_pattern_not_matched_objclass=pattern_not_matched_objclass.find(source_interface_pre);
							if(p_pattern_not_matched_objclass != pattern_not_matched_objclass.end()){
								do{
									//os_policy << "matchobjclass:" << p_pattern_not_matched_objclass->second << ";" << endl;
									v_matched_tmp_objclass.push_back(p_pattern_not_matched_objclass->second.c_str());
									p_pattern_not_matched_objclass++;
								}while(p_pattern_not_matched_objclass != pattern_not_matched_objclass.upper_bound(source_interface_pre));
							}
							p_pattern_not_matched_domain=pattern_not_matched_domain.find(source_interface_pre);
							if(p_pattern_not_matched_domain != pattern_not_matched_domain.end()){
								do{
									//os_policy << p_pattern_not_matched_domain->second << endl;
									v_matched_tmp_domain.push_back(p_pattern_not_matched_domain->second.c_str());
									p_pattern_not_matched_domain++;
								}while(p_pattern_not_matched_domain != pattern_not_matched_domain.upper_bound(source_interface_pre));
							}
							p_pattern_not_matched_tclass=pattern_not_matched_tclass.find(source_interface_pre);
							if(p_pattern_not_matched_tclass != pattern_not_matched_tclass.end()){
								do{
									//os_policy << p_pattern_not_matched_tclass->second << endl;
									v_matched_tmp_domain.push_back(p_pattern_not_matched_tclass->second.c_str());
									p_pattern_not_matched_tclass++;
								}while(p_pattern_not_matched_tclass != pattern_not_matched_tclass.upper_bound(source_interface_pre));
							}
						}
						source_interface_pre_comp = source_interface_pre;
					}
					/*ޥåʤäȤεߺѺǡallowʸФ*/
					//os_policy << source_interface_pre ;
					//os_policy << " was_not_matched !!!!!!!!"<< endl;
					/*ޥåʤäۤϡǤޤȤơ٥ƥʤѤǤ夫饽ȥˡƽФ*/	
					p_pattern_not_matched_objclass=pattern_not_matched_objclass.find(source_interface_pre);
					if(p_pattern_not_matched_objclass != pattern_not_matched_objclass.end()){
						do{
							//os_policy << "matcheʤäobjclass:" << p_pattern_not_matched_objclass->second << ";" << endl;
							// 2ܤϡ826
							v_tmp_objclass.push_back(p_pattern_not_matched_objclass->second.c_str());
							p_pattern_not_matched_objclass++;
						}while(p_pattern_not_matched_objclass != pattern_not_matched_objclass.upper_bound(source_interface_pre));
					}
					p_pattern_not_matched_domain=pattern_not_matched_domain.find(source_interface_pre);
					if(p_pattern_not_matched_domain != pattern_not_matched_domain.end()){
						do{
					//		os_policy << p_pattern_not_matched_domain->second << endl;
							v_tmp_domain.push_back(p_pattern_not_matched_domain->second.c_str());
							p_pattern_not_matched_domain++;
						}while(p_pattern_not_matched_domain != pattern_not_matched_domain.upper_bound(source_interface_pre));
					}
					p_pattern_not_matched_tclass=pattern_not_matched_tclass.find(source_interface_pre);
					if(p_pattern_not_matched_tclass != pattern_not_matched_tclass.end()){
						do{
					//		os_policy << p_pattern_not_matched_tclass->second << endl;
							v_tmp_domain.push_back(p_pattern_not_matched_tclass->second.c_str());
							p_pattern_not_matched_tclass++;
						}while(p_pattern_not_matched_tclass != pattern_not_matched_tclass.upper_bound(source_interface_pre));
					}
				}
				/*end read the engine agin and check...*/
				/*2ܤθꤳܤʬȤ󥿥եäƤ*/
				for(p_interface_raw=v_interface_raw.begin(); p_interface_raw < v_interface_raw.end(); p_interface_raw++){
					//ʸϡsource_interface_raw ʤ㡧userdom_manage_generic_user_home_content_files
					string source_interface_raw = *p_interface_raw;
					const char* m_source_interface_raw = source_interface_raw.c_str();
					const char* m_domain_interface_h = "[a-z0-9_]*_t:";
					const char* m_objclass_interface_h = ":(.*)\\{";
					const char* m_objclass_interface_h2 = ":(.*)([^[:space:]*])[[:space:]]";
					const char* m_accv_interface_h = "\\{(.*)\\}";
					const char* m_accv_interface_h2 = "[[:space:]][a-z0-9_]*;,";
					string blank_str="";
					string space_str=" ";
					regex m_source_interface_raw_exp(m_source_interface_raw);
					regex m_domain_interface_h_exp(m_domain_interface_h);
					regex m_objclass_interface_h_exp(m_objclass_interface_h);
					regex m_objclass_interface_h2_exp(m_objclass_interface_h2);
					regex m_accv_interface_h_exp(m_accv_interface_h);
					regex m_accv_interface_h2_exp(m_accv_interface_h2);
					/*read the engine and check*/
					/*󥸥ե夫鸡롣forפСޥåƤ*/
					/*⤦󡢼ꤳܤobjectclass򸡺*/
					string domain_interface_h;
					string objclass_interface_h;
					string objclass_interface_h2;
					string accv_interface_h;
					string accv_interface_h2;
					for(p_engine=v_engine.begin(); p_engine < v_engine.end(); p_engine++){
						string source_engine = *p_engine;
						const char* source_engine_str = source_engine.c_str();
						cmatch what;
						if(regex_search(source_engine_str,what,m_source_interface_raw_exp)){
							string source_interface_raw = what[0];
							//const char* source_interface_raw_str = source_interface_raw.c_str();
							//os_policy << source_interface_raw << endl;	
							if(regex_search(source_engine_str,what,m_domain_interface_h_exp)){
								domain_interface_h = what[0];
								int length=strlen(domain_interface_h.c_str());
								domain_interface_h=domain_interface_h.replace(length-1,1,blank_str);
								//domainѤǤ
								//Ǥϡv_matched_tmp_domainѤࡣ
								v_matched_tmp_domain.push_back(domain_interface_h.c_str());
								//os_policy << domain_interface_h << endl;	
							}
							if(regex_search(source_engine_str,what,m_objclass_interface_h_exp)){
								objclass_interface_h = what[0];
								objclass_interface_h=objclass_interface_h.replace(0,1,blank_str);
								int length=strlen(objclass_interface_h.c_str());
								objclass_interface_h=objclass_interface_h.replace(length-2,2,blank_str);
								//os_policy << "objclass_interface_h:" << objclass_interface_h <<endl;
								//v_tmp_objclassϡ¤ϸΥȤʤΤǡ֤줿(󥿥եäƤ)
								//objclassѤǤʤȥᡣ
								//Ǥϡv_matched_tmp_objclassѤߡȤv_tmp_objclass˲ä
								v_matched_tmp_objclass.push_back(objclass_interface_h.c_str());
								objclass_interface_h = objclass_interface_h + space_str ;
								//os_policy << objclass_interface_h << endl;	
							}
							/*С2.02ɮʬʥ٥{}ǰϤޤƤ櫓Ǥ̵*/
							if(regex_search(source_engine_str,what,m_objclass_interface_h2_exp)){
								objclass_interface_h2 = what[0];
								objclass_interface_h2=objclass_interface_h2.replace(0,1,blank_str);
								int length=strlen(objclass_interface_h2.c_str());
								objclass_interface_h2=objclass_interface_h2.replace(length-1,1,blank_str);
								//os_policy << "objclass_interface_h2:" << objclass_interface_h2 <<endl;
								//v_tmp_objclassϡ¤ϸΥȤʤΤǡ֤줿(󥿥եäƤ)
								//objclassѤǤʤȥᡣ
								//Ǥϡv_matched_tmp_objclassѤߡȤv_tmp_objclass˲ä
								v_matched_tmp_objclass.push_back(objclass_interface_h2.c_str());
								objclass_interface_h2 = objclass_interface_h2 + space_str ;
							}
							if(regex_search(source_engine_str,what,m_accv_interface_h_exp)){
								accv_interface_h = what[0];
								string bracket_first_str="{";
								string bracket_last_str="{";
								accv_interface_h=accv_interface_h.replace(0,1,blank_str);
								int length=strlen(accv_interface_h.c_str());
								accv_interface_h=accv_interface_h.replace(length -1,1,blank_str);
								//os_policy << accv_interface_h << endl;	
								regex tmp_re("[[:space:]]([^[:space:]]*)[a-z0-9_]*");
								string::const_iterator it=accv_interface_h.begin(), end=accv_interface_h.end();
								while(it != end){
									smatch result;
									if( !regex_search(it, end, result, tmp_re)){
										break;
									}
									pattern_matched_access_vector.insert(pair<string, string>(objclass_interface_h,result.str()));
									//os_policy << "interface<" <<objclass_interface_h << ":" << result.str() << ">" << endl;
									//os_policy << "interfaceäƤobjclass:" << objclass_interface_h << "; <<<< endl;
									v_matched_tmp_objclass.push_back(objclass_interface_h.c_str());
									it = result[0].second;
								}
							}
							/*С2.02ɮʬʥ٥{}ǰϤޤƤ櫓Ǥ̵*/
							if(regex_search(source_engine_str,what,m_accv_interface_h2_exp)){
								accv_interface_h2 = what[0];
								int length=strlen(accv_interface_h2.c_str());
								accv_interface_h2=accv_interface_h2.replace(length -2,2,blank_str);
								//os_policy << accv_interface_h2 << endl;
								//os_policy << "interface<" <<objclass_interface_h2 << ":" << accv_interface_h2 << ">" << endl;
								pattern_matched_access_vector.insert(pair<string, string>(objclass_interface_h2,accv_interface_h2));
							}
						}
					}
				}
				is.close();
				/*class νϡ٥ޤȤ뤿˽򤷤ƤФ*/
				/*̤Ƥtmp_strǡpattern_not_matched_access_vectorȤmultimap򸡺*/
				/*tmp_strmultimap裲°äС٥*/
				/*tmp_str˲äС}ԤäơƤ*/
				/*κݡ󥿥ե˥ޥåΤޤȤƤ*/
				/*ޤȤϡ󥿥եõʤäѿˡõΤѤǤǤ*/

				/*ޤʸǤobjclassޤȤ*/
				int v_matched_tmp_objclass_size=v_matched_tmp_objclass.size();
				for(int i=0;i < v_matched_tmp_objclass_size;i++){
					v_tmp_objclass.push_back(v_matched_tmp_objclass[i].c_str());
					string test = v_matched_tmp_objclass[i];
					//os_policy << "test:" << test << endl;
				}
				/*ˡ¦ǤmultimapޤȤ*/
				/*multimapΥƥ졼Ȥä...*/
				p_pattern_matched_access_vector=pattern_matched_access_vector.begin();
				do{

					string objclass_matched_echo = p_pattern_matched_access_vector->first;
					string accv_matched_echo = p_pattern_matched_access_vector->second;
					//os_policy << "final<" << objclass_matched_echo << ":" << accv_matched_echo << ">" << endl;
					string blank_str="";
					string space_first_str=" ";
					int length=strlen(objclass_matched_echo.c_str());
					objclass_matched_echo=objclass_matched_echo.replace(length -1,1,blank_str);
					int space_first_position=accv_matched_echo.find_first_of(space_first_str);
					accv_matched_echo=accv_matched_echo.replace(0,space_first_position + 1,blank_str);
					pattern_not_matched_access_vector.insert(pair<string, string>(objclass_matched_echo,accv_matched_echo));
					p_pattern_matched_access_vector++;
				}while(p_pattern_matched_access_vector != pattern_matched_access_vector.end());

				sort(v_tmp_objclass.begin(),v_tmp_objclass.end());
				p_tmp_objclass_end=unique(v_tmp_objclass.begin(),v_tmp_objclass.end());

				os_policy << "####################################################" << endl;
				os_policy << "##### This file was generated by segatex2.02" << endl;
				os_policy << "####################################################" << endl;
				os_policy << "#### $make -f /usr/share/selinux/devel/Makefile" << endl;
				os_policy << "#### will generate module in this directory." << endl;
				os_policy << "#### #semodule -i my_policy_by_segatex.pp" << endl;
				os_policy << "#### will install module to your system."<< endl;
				os_policy << "#### To check, #semodule -l" << endl;
				os_policy << "#### To uninstall, #semodule -r my_policy_by_segatex" << endl;
				os_policy << "####################################################" << endl;
				os_policy << "module my_policy_by_segatex 1.0.0;" << endl << endl;
				os_policy << "require {" << endl;
				string p_pattern_not_matched_objclass_pre=*v_tmp_objclass.begin();
				for(p_tmp_objclass=v_tmp_objclass.begin(); p_tmp_objclass < p_tmp_objclass_end; p_tmp_objclass++){
					string tmp_str= *p_tmp_objclass;
					//os_policy << "tmp_str:" << tmp_str << endl;
					/*ǤϡޥåʤäΤȡΤȡ󥿥եäƤobjclassaccess_vectorƳФƤ*/
					p_pattern_not_matched_access_vector=pattern_not_matched_access_vector.find(tmp_str);
					if(p_pattern_not_matched_access_vector != pattern_not_matched_access_vector.end()){
						os_policy << "	class " << p_pattern_not_matched_access_vector->first << " { " ;
						do{
							if(p_pattern_not_matched_access_vector->first == p_pattern_not_matched_objclass_pre){
								//os_policy << p_pattern_not_matched_access_vector->second << " ";
								v_accv.push_back(p_pattern_not_matched_access_vector->second.c_str());
							}
							p_pattern_not_matched_objclass_pre = p_pattern_not_matched_access_vector->first;
							p_pattern_not_matched_access_vector++;
						}while(p_pattern_not_matched_access_vector != pattern_not_matched_access_vector.upper_bound(tmp_str));
						sort(v_accv.begin(),v_accv.end());
						p_accv_end=unique(v_accv.begin(),v_accv.end());
						for(p_accv=v_accv.begin(); p_accv < p_accv_end; p_accv++){
							string accv_str= *p_accv;
							os_policy << accv_str << " ";
						}
						os_policy << " };" << endl;
						v_accv.clear();
					}
				}

				os_policy << endl;
				/*type ϡdomaintclassޤȤƽФ*/
				/*κݡ󥿥ե˥ޥåΤȥޥåʤäΤޤȤƤ*/
				int v_matched_tmp_domain_size=v_matched_tmp_domain.size();
				for(int i=0;i < v_matched_tmp_domain_size;i++){
					v_tmp_domain.push_back(v_matched_tmp_domain[i].c_str());
					//string test = v_matched_tmp_domain[i];
					//os_policy << test << endl;
				}
				sort(v_tmp_domain.begin(),v_tmp_domain.end());
				p_tmp_domain_end=unique(v_tmp_domain.begin(),v_tmp_domain.end());
				for(p_tmp_domain=v_tmp_domain.begin();p_tmp_domain < p_tmp_domain_end; p_tmp_domain++){
					string dom_str = *p_tmp_domain;
					os_policy << "	type " << dom_str << ";" << endl;
				}
				os_policy << "}" << endl << endl;
				/*ޥåʤäallowʸФ*/
				cmatch what;
				const char* m_snmfp = "(.*):([^[:space:]]*)([:space:])?";
				const char* m_acc_comp = "\\{(.*)\\}";
				regex m_snmfp_exp(m_snmfp);
				regex m_acc_comp_exp(m_acc_comp);
				/*read the allow sentence and divide*/
				for(p2_v=v2.begin();p2_v < p2_v_end; p2_v++){
					string source_not_match_final_pre = *p2_v;
					const char* m_source_not_match_final_pre = source_not_match_final_pre.c_str();
					string allow_first  = what[0];
					string allow_last  = what[0];
					if(regex_search(m_source_not_match_final_pre,what,m_snmfp_exp)){
						allow_first  = what[0];
						v_allow_first.push_back(allow_first.c_str());
						//os_policy << allow_first << endl;
					if(regex_search(m_source_not_match_final_pre,what,m_acc_comp_exp)){
						allow_last  = what[0];
						int length=strlen(allow_last.c_str());
						string blank_str="";
						allow_last=allow_last.replace(length - 2,2,blank_str);
						allow_last=allow_last.replace(0,2,blank_str);
						//os_policy << allow_last << endl;
					}
						/*ޥޥåפѤǤ*/
						pattern_allow_not_matched_echo.insert(pair<string, string>(allow_first,allow_last));
					}
				}
				/*allow backup_t sysadm_devpts_t:chr_fileȤv_allow_first򸵼ˡ
				pattern_allow_not_matched_echo򸡺
				ΤȤۤȤƱɽΤäȰ㤦
				*/
				sort(v_allow_first.begin(),v_allow_first.end());
				p_allow_first_end=unique(v_allow_first.begin(),v_allow_first.end());
				string p_allow_first_str=*v_allow_first.begin();
				for(p_allow_first=v_allow_first.begin(); p_allow_first < p_allow_first_end; p_allow_first++){
					string tmp_str= *p_allow_first;
					p_pattern_allow_not_matched_echo=pattern_allow_not_matched_echo.find(tmp_str);
					if(p_pattern_allow_not_matched_echo != pattern_allow_not_matched_echo.end()){
						/*ո©ɡޤ*/
						os_policy << p_pattern_allow_not_matched_echo->first << " { " ;
						if(p_pattern_allow_not_matched_echo != pattern_allow_not_matched_echo.begin()){
							os_policy <<  p_pattern_allow_not_matched_echo->second.c_str() << " ";
						}
						/*פƤС٥*/
						do{
							if(p_pattern_allow_not_matched_echo->first == p_allow_first_str){
								v_allow_last.push_back(p_pattern_allow_not_matched_echo->second.c_str());
							}
							p_allow_first_str = p_pattern_allow_not_matched_echo->first;
							p_pattern_allow_not_matched_echo++;
						}while(p_pattern_allow_not_matched_echo != pattern_allow_not_matched_echo.upper_bound(tmp_str));
						sort(v_allow_last.begin(),v_allow_last.end());
						p_allow_last_end=unique(v_allow_last.begin(),v_allow_last.end());
						for(p_allow_last=v_allow_last.begin(); p_allow_last < p_allow_last_end; p_allow_last++){
							string allow_last_str= *p_allow_last;
							os_policy << allow_last_str << " ";
						}
						os_policy << " };" << endl;
						v_allow_last.clear();
					}
				}
				//󥿥եФ
				sort(v_domain_interface.begin(),v_domain_interface.end());
				p_domain_interface_end=unique(v_domain_interface.begin(),v_domain_interface.end());
				for(p_domain_interface=v_domain_interface.begin(); p_domain_interface < p_domain_interface_end; p_domain_interface++){
					string domain_interface_echo_final = *p_domain_interface;	
					os_policy << domain_interface_echo_final << endl;
				}

				QFile file( filename_policy); // Read the text from a file
				if ( file.open( IO_ReadOnly ) ) {
					QTextStream stream( &file );
					textEdit1->setText( stream.read() );
				}
			}
			os_policy.close();
		}
		is.close();
	}
	is_engine.close();
}
