/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.search;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Proxy;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import slothLib.portUtil.PortUtil;
import slothLib.web.search.IVideoSearch;
import slothLib.web.search.WebSearchException;
import slothLib.web.search.YouTubeElement;
import slothLib.web.search.YouTubeException;
import slothLib.web.search.YouTubeSearchResult;

public class YouTubeSearch
implements IVideoSearch {
    private String dev_id;
    private Proxy proxy;

    public YouTubeSearch(String dev_id) {
        this.dev_id = dev_id;
    }

    @Override
    public YouTubeSearchResult doSearch(String query, int resultNum) throws WebSearchException {
        return this.doSearchOver(query, resultNum);
    }

    private YouTubeSearchResult doSearchOriginal(String query, int resultNum, int page) throws WebSearchException {
        ArrayList<YouTubeElement> result = new ArrayList<YouTubeElement>();
        String url = this.makeYouTubeQuery(query, page, resultNum);
        System.err.println(url);
        Document xmlDoc = PortUtil.getDocumentFromURL(url, this.proxy);
        Element rootElement = xmlDoc.getDocumentElement();
        long totalNumber = 0L;
        try {
            totalNumber = Long.parseLong(rootElement.getChildNodes().item(0).getChildNodes().item(0).getTextContent());
        }
        catch (NumberFormatException e) {
            totalNumber = 0L;
        }
        String status = rootElement.getAttribute("status");
        if (status.equals("fail")) {
            String code = rootElement.getElementsByTagName("code").item(0).getTextContent();
            throw new YouTubeException(code);
        }
        NodeList videoList = rootElement.getElementsByTagName("video");
        int i = 0;
        while (i < videoList.getLength()) {
            Node video = videoList.item(i);
            String author = video.getChildNodes().item(0).getTextContent();
            String id = video.getChildNodes().item(1).getTextContent();
            String title = video.getChildNodes().item(2).getTextContent();
            String length_seconds = video.getChildNodes().item(3).getTextContent();
            String rating_avg = video.getChildNodes().item(4).getTextContent();
            String rating_count = video.getChildNodes().item(5).getTextContent();
            String description = video.getChildNodes().item(6).getTextContent();
            String view_count = video.getChildNodes().item(7).getTextContent();
            String date = video.getChildNodes().item(8).getTextContent();
            String commnet_count = video.getChildNodes().item(9).getTextContent();
            String tags = video.getChildNodes().item(10).getTextContent();
            tags = "[" + tags + "]";
            tags = tags.replace(" ", "] [");
            String uri = video.getChildNodes().item(11).getTextContent();
            String thumbnail_url = video.getChildNodes().item(12).getTextContent();
            YouTubeElement element = new YouTubeElement(this.safeString(author), this.safeString(id), this.safeString(title), this.strToInt(length_seconds), this.strToDouble(rating_avg), this.strToInt(rating_count), this.safeString(description), this.strToInt(view_count), this.UnixTimeStampToDateTime(date), this.strToInt(commnet_count), this.safeString(tags), this.safeString(uri), this.safeString(thumbnail_url));
            result.add(element);
            System.err.println(element.toString());
            ++i;
        }
        return new YouTubeSearchResult(query, totalNumber, result.toArray(new YouTubeElement[0]));
    }

    private String makeYouTubeQuery(String tag, int page, int per_page) {
        String requestURL = "http://www.youtube.com/api2_rest?method=youtube.videos.list_by_tag&dev_id=" + this.dev_id + "&tag=" + tag + "&page=" + page + "&per_page=" + per_page;
        return PortUtil.absoluteUri(requestURL);
    }

    public String getComment(String dev_id, String video_id) throws WebSearchException {
        String comment_str = "";
        String detail_url = "http://www.youtube.com/api2_rest?method=youtube.videos.get_details&dev_id=" + dev_id + "&video_id=" + video_id;
        Document detail_xmlDoc = PortUtil.getDocumentFromURL(detail_url, this.proxy);
        Element detail_rootElement = detail_xmlDoc.getDocumentElement();
        String status = detail_rootElement.getAttribute("status");
        if (!status.equals("ok") && status.equals("fail")) {
            NodeList nl = detail_rootElement.getElementsByTagName("code");
            String code = nl.item(0).getTextContent();
            throw new YouTubeException(code);
        }
        NodeList commentList = detail_rootElement.getElementsByTagName("comment");
        if (commentList != null) {
            int index = 0;
            while (index < commentList.getLength()) {
                Node comment = commentList.item(index);
                comment_str = String.valueOf(comment_str) + " " + comment.getChildNodes().item(1).getTextContent();
                ++index;
            }
        }
        return comment_str;
    }

    public String getSwfUrl(String videoID) {
        String request = "GET /watch_video?v=" + videoID + " HTTP/1.0\r\n";
        request = String.valueOf(request) + "Connection: Close\r\n";
        request = String.valueOf(request) + "\r\n";
        String server = "www.youtube.com";
        String path = "/watch_video?v=" + videoID;
        String reqMsg = "GET " + path + " HTTP/1.0\r\n" + "Connection: Close\r\n\r\n";
        String resMsg = this.socketConnect(server, reqMsg);
        int start = resMsg.indexOf("&t=") + 3;
        int end = resMsg.indexOf("\n", start);
        String t = resMsg.substring(start, end - start - 1);
        String swfURL = "http://www.youtube.com/player2.swf?video_id=" + videoID + "&t=" + t;
        return swfURL;
    }

    public String getVideoUrl(String videoID) {
        String request = "GET /watch_video?v=" + videoID + " HTTP/1.0\r\n";
        request = String.valueOf(request) + "Connection: Close\r\n";
        request = String.valueOf(request) + "\r\n";
        String server = "www.youtube.com";
        String path = "/watch_video?v=" + videoID;
        String reqMsg = "GET " + path + " HTTP/1.0\r\n" + "Connection: Close\r\n\r\n";
        String resMsg = this.socketConnect(server, reqMsg);
        int start = resMsg.indexOf("&t=") + 3;
        int end = resMsg.indexOf("\n", start);
        String t = resMsg.substring(start, end - start - 1);
        String path2 = "/get_video?video_id=" + videoID + "&t=" + t;
        String reqMsg2 = "GET " + path2 + " HTTP/1.0\r\n" + "Connection: Keep-Alive\r\n\r\n";
        String resMsg2 = this.socketConnect(server, reqMsg2);
        int start2 = resMsg2.indexOf("Location:") + 10;
        int end2 = resMsg2.indexOf("\r\n", start2);
        String videoURL = resMsg2.substring(start2, end2 - start2);
        return videoURL;
    }

    private String socketConnect(String server, String reqMsg) {
        try {
            Socket sock = new Socket(server, 80);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(sock.getOutputStream()));
            pw.write(reqMsg);
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(sock.getInputStream()));
            StringBuilder resMsg = new StringBuilder();
            String str = null;
            while ((str = lnr.readLine()) != null) {
                resMsg.append(str);
                resMsg.append("\n");
            }
            sock.close();
            return resMsg.toString();
        }
        catch (IOException e) {
            return "Error";
        }
    }

    private Date UnixTimeStampToDateTime(String date) {
        try {
            double tmp = Double.parseDouble(date);
            return new Date((long)(tmp * 1000.0));
        }
        catch (NumberFormatException e) {
            return new Date();
        }
    }

    private int strToInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private double strToDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private String safeString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    private YouTubeSearchResult doSearchOver(String query, int resultNum) throws WebSearchException {
        int loop = (resultNum - 1) / 100;
        ArrayList<YouTubeElement> resultElements = new ArrayList<YouTubeElement>();
        int i = 0;
        while (i < loop) {
            resultElements.addAll(Arrays.asList(this.doSearchOriginal(query, 100, i + 1).getResultElements()));
            ++i;
        }
        YouTubeSearchResult searchResult = this.doSearchOriginal(query, resultNum - loop * 100, loop + 1);
        resultElements.addAll(Arrays.asList(searchResult.getResultElements()));
        return new YouTubeSearchResult(query, searchResult.getTotalNumber(), resultElements.toArray(new YouTubeElement[0]));
    }

    public void setProxy(String value) {
        this.proxy = PortUtil.isNullOrEmpty(value) ? null : PortUtil.createProxy(value);
    }

    public String getProxy() {
        return PortUtil.getProxyURL(this.proxy);
    }
}

