/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.matrix;

import slothLib.linearAlgebra.matrix.BasicMatrix;
import slothLib.linearAlgebra.matrix.IMatrix;

public class MultiplyMatrix
extends BasicMatrix {
    public MultiplyMatrix(IMatrix matrix1, IMatrix matrix2) {
        super(matrix1.rowCount(), matrix2.columnCount());
        if (matrix1.columnCount() != matrix2.rowCount()) {
            throw new IllegalArgumentException("\u5de6\u884c\u5217\u306e\u5217\u6570\u3068\u53f3\u884c\u5217\u306e\u884c\u6570\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        this.format();
        this.calculate(matrix1, matrix2);
    }

    private void format() {
        int i = 0;
        while (i < this.rowCount()) {
            int j = 0;
            while (j < this.columnCount()) {
                this.set(i, j, 0.0);
                ++j;
            }
            ++i;
        }
    }

    private void calculate(IMatrix matrix1, IMatrix matrix2) {
        int i = 0;
        while (i < this.rowCount()) {
            int j = 0;
            while (j < this.columnCount()) {
                this.set(i, j, 0.0);
                int k = 0;
                while (k < matrix2.rowCount()) {
                    this.set(i, j, this.get(i, j) + matrix1.get(i, k) * matrix2.get(k, j));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

