<?php
require_once('config.php');
header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past
if (file_exists(LISM))
{
    $lismxml = simplexml_load_file(LISM); 
}
else 
{
    echo('ファイルが開けません。: '. LISM);
    exit(1);
}

$system = $_GET["system"];
//////////////////////////////////////////////////
////////////////データベース情報の更新////////////
if (isset($_GET["dbserver"])
    && isset($_GET["host"]) 
    && isset($_GET["database"])
    && isset($_GET["user"])
    && isset($_GET["password"])
    && isset($_GET["table"]))
{
    $dbserver = $_GET['dbserver'];
    $host = $_GET['host'];
    $database = $_GET['database'];
    $user = $_GET['user'];
    $password = $_GET['password'];
    $pwhash = $_GET['pwhash'];
    $table = $_GET['table'];
    $charcode = $_GET['charcode'];

    foreach ($lismxml->data as $v)
    {
        $system_elt = (string)$v->attributes()->name;
        if ($system_elt == $system)
        {
            //database, host
            $dsn = '';
            switch($dbserver) {
              case 'mysql':
                $dsn = "DBI:mysql:$database:$host";
                break;
              case 'pgsql':
                $dsn = "DBI:Pg:dbname=$database;host=$host";
                break;
              case 'oci8':
                $dsn = "DBI:Oracle:host=$host;sid=$database";
                break;
              default;
            }
            $v->storage->dsn = $dsn;
            $v->storage->admin = $user;
            $v->storage->passwd = $password;
            $v->storage->attributes()->hash = $pwhash;
            $v->storage->mbcode = $charcode;

            //table
            foreach ($v->storage->object as $vv)
            {
                if ((string)$vv->attributes()->name == 'User')
                {
                    $vv->table = $table;
                }
            }
            break;
        }
    }
}
//////////////////////////////////////////////////
////////////////フィールド配置の更新//////////////
if (isset($_GET["checked"])
    && isset($_GET["master"])
    && isset($_GET["field"])) 
{
    if (!empty($_GET["master"])) {
        $checked = explode(",", $_GET["checked"]);
        $master = explode(",", $_GET["master"]);
        $field = explode(",", $_GET["field"]);
    }
    else {
        $checked = $master = $field = array();
    }
    //sync部分の処理：追加、削除
    $syncattr_del = array();
    $syncattr_add = array();
    foreach ($master as $k => $v)
    {
        if ($v == 'primary key' || $v == 'uid') {
            continue;
        }

        if ($checked[$k] && !in_array($v, $syncattr_add))
        {
            $syncattr_add[] = $v;
        }
        else
        {
            $syncattr_del[] = $v;
        }
    }
    foreach ($lismxml->sync->data as $v)
    {
        $system_elt = (string)$v->attributes()->name;
        if ($system_elt == $system || $system_elt == 'IDP')
        {
            //削除
            $rmObjs = array();
            if (isset($v->object->syncattr)) {
                foreach ($v->object->syncattr as $vv)
                {
                    if (in_array(strtolower((string)$vv->name), $syncattr_add))
                    {
                        unset($syncattr_add[array_search(strtolower((string)$vv->name), $syncattr_add)]);
                    }
                    if (in_array(strtolower((string)$vv->name), $syncattr_del))
                    { 
                        $dom=dom_import_simplexml($vv);
                        $parent = $dom->parentNode;
                        // $parent->removeChild($dom);
                        $rmObjs[] = array('parent'=>$parent, 'dom'=>$dom);
                    }
                }
            }
            foreach ($rmObjs as $v_r)
            {
                $parent = $v_r['parent'];
                $parent->removeChild($v_r['dom']);
            }
            //追加
            foreach ($syncattr_add as $vv_a)
            {
                $attr = $v->object->addChild('syncattr');
                $attr->addChild('name', $vv_a);
                if (preg_match('/^(userPassword)$/i', $vv_a)) {
                    $attr->addChild('op', 'add');
                }
            }
        }
    }
    //data部分の処理：追加、更新
    $attr = array();
    foreach ($master as $k => $v)
    {
        $attr[$v] = $field[$k];
    }
    foreach ($lismxml->data as $v)
    {
        $system_elt = (string)$v->attributes()->name;
        if ($system_elt == $system)
        {
            $rm2Objs = array();
            foreach ($v->storage->object as $vv)
            {
                if ((string)$vv->attributes()->name == 'User')
                {
                    if (in_array('primary key', $master)) {
                        $vv->id[0]->column = $attr['primary key'];
                        unset($attr['primary key']);
                    }

                    foreach ($vv->attr as $vvv)
                    {
                        $name = (string)$vvv->attributes()->name;
                        if (!isset($vvv->column)) {
                            continue;
                        }

                        //フィールド更新
                        if (in_array($name, $master))
                        {
                            $vvv->column = $attr[$name];
                            unset($attr[$name]);
                        }
                        else 
                        {
                            $dom=dom_import_simplexml($vvv);
                            $parent = $dom->parentNode;
                            // $parent->removeChild($dom);
                            $rm2Objs[] = array('parent'=>$parent, 'dom'=>$dom);
                        }
                    }
                    //フィールド削除
                    foreach ($rm2Objs as $v_r2)
                    {
                        $parent = $v_r2['parent'];
                        $parent->removeChild($v_r2['dom']);
                    }
                    //フィールド追加
                    foreach ($attr as $ak=>$av)
                    {
                        $attr_add = $vv->addChild('attr');
                        $attr_add->addAttribute('name', $ak);
                        $attr_add->addChild('column', $av);
                    }
                }
            }
        }
    }
}
//////////////////////////////////////////////////
//////////更新された配置をファイルに保存//////////
$dom = new DOMDocument('1.0'); 
$dom->preserveWhiteSpace = false; 
$dom->formatOutput = true; 
$dom->loadXML($lismxml->asXML());

$sp = fopen(LISM,"wb");
if ($sp === false) {
    echo "更新に失敗しました。";
    exit(0);
}
if (fwrite($sp, $dom->saveXML()) === false) {
    echo "更新に失敗しました。";
    exit(0);
}
fclose($sp);

echo "更新しました。";
?>
