<?php

/**
 * @file
 * Sample authorize endpoint.
 *
 * Obviously not production-ready code, just simple and to the point.
 *
 * In reality, you'd probably use a nifty framework to handle most of the crud for you.
 */

$logid = 'OAuth2';

require "lib/PDOOAuth2.inc";
require_once("/var/www/lib/util.php");

$conf = parse_ini_file("/var/www/conf/oauth.conf");
if (empty($conf)) {
     $log->crit(logformat("Can't read config.ini"));
     exit(1);
}

if (!isset($_SERVER['REMOTE_USER'])) {
     $log->err(logformat("User isn't authenticated"));
     exit(1);
}

if (isset($conf['sessionname']) && isset($conf['loginurl']) && !isset($_SERVER['REMOTE_USER_LOGGEDIN'])) {
    $url = (isset($_SERVER['HTTPS']) ? 'https' : 'http').'://'.$_SERVER['HTTP_HOST'].':'.$_SERVER['SERVER_PORT'].$_SERVER['REQUEST_URI'];
    header('Location: '.$conf['loginurl'].(strpos($conf['loginurl'], '?') === false ? '?' : '&').'url_back='.urlencode($url));
    exit(0);
}

$oauth = new PDOOAuth2($conf);

$params = array();
foreach ($_GET as $key => $value) {
    switch ($key) {
      case 'client_id':
      case 'redirect_uri':
      case 'state':
        $params[$key] = $value;
        break;
    }
}
$params['response_type'] = 'code';
$params['username'] = $_SERVER['REMOTE_USER'];

$oauth->finishClientAuthorization(TRUE, $params);
