package org.seasar.hibernate.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Query;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.type.Type;

import org.seasar.hibernate.HibernateRuntimeException;
import org.seasar.hibernate.S2Session;

/**
 * @author higa
 *
 */
public class S2SessionImpl implements S2Session {

	private Session session_;

	/**
	 * 
	 */
	public S2SessionImpl(Session session) {
		session_ = session;
	}

	/**
	 * @see org.seasar.hibernate.S2Session#getSession()
	 */
	public Session getSession() {
		return session_;
	}

	/**
	 * @see org.seasar.hibernate.S2Session#flush()
	 */
	public void flush() throws HibernateRuntimeException {
		try {
			session_.flush();
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#setFlushMode(net.sf.hibernate.FlushMode)
	 */
	public void setFlushMode(FlushMode flushMode) {
		session_.setFlushMode(flushMode);
	}

	/**
	 * @see org.seasar.hibernate.S2Session#getFlushMode()
	 */
	public FlushMode getFlushMode() {
		return session_.getFlushMode();
	}

	/**
	 * @see org.seasar.hibernate.S2Session#getSessionFactory()
	 */
	public SessionFactory getSessionFactory() {
		return session_.getSessionFactory();
	}

	/**
	 * @see org.seasar.hibernate.S2Session#connection()
	 */
	public Connection connection() throws HibernateRuntimeException {
		try {
			return session_.connection();
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#disconnect()
	 */
	public Connection disconnect() throws HibernateRuntimeException {
		try {
			return session_.disconnect();
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#reconnect()
	 */
	public void reconnect() throws HibernateRuntimeException {
		try {
			session_.reconnect();
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}

	}

	/**
	 * @see org.seasar.hibernate.S2Session#reconnect(java.sql.Connection)
	 */
	public void reconnect(Connection connection)
		throws HibernateRuntimeException {

		try {
			session_.reconnect(connection);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}

	}

	/**
	 * @see org.seasar.hibernate.S2Session#close()
	 */
	public Connection close() throws HibernateRuntimeException {
		try {
			return session_.close();
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#cancelQuery()
	 */
	public void cancelQuery() throws HibernateRuntimeException {
		try {
			session_.cancelQuery();
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#isOpen()
	 */
	public boolean isOpen() {
		return session_.isOpen();
	}

	/**
	 * @see org.seasar.hibernate.S2Session#isConnected()
	 */
	public boolean isConnected() {
		return session_.isConnected();
	}

	/**
	 * @see org.seasar.hibernate.S2Session#isDirty()
	 */
	public boolean isDirty() throws HibernateRuntimeException {
		try {
			return session_.isDirty();
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#getIdentifier(java.lang.Object)
	 */
	public Serializable getIdentifier(Object object)
		throws HibernateRuntimeException {

		try {
			return session_.getIdentifier(object);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#contains(java.lang.Object)
	 */
	public boolean contains(Object object) {
		return session_.contains(object);
	}

	/**
	 * @see org.seasar.hibernate.S2Session#evict(java.lang.Object)
	 */
	public void evict(Object object) throws HibernateRuntimeException {
		try {
			session_.evict(object);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}

	}

	/**
	 * @see org.seasar.hibernate.S2Session#load(java.lang.Class, java.io.Serializable, net.sf.hibernate.LockMode)
	 */
	public Object load(Class theClass, Serializable id, LockMode lockMode)
		throws HibernateRuntimeException {

		try {
			return session_.load(theClass, id, lockMode);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#load(java.lang.Class, java.io.Serializable)
	 */
	public Object load(Class theClass, Serializable id)
		throws HibernateRuntimeException {

		try {
			return session_.load(theClass, id);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#load(java.lang.Object, java.io.Serializable)
	 */
	public void load(Object object, Serializable id)
		throws HibernateRuntimeException {

		try {
			session_.load(object, id);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#replicate(java.lang.Object, net.sf.hibernate.ReplicationMode)
	 */
	public void replicate(Object object, ReplicationMode replicationMode)
		throws HibernateRuntimeException {

		try {
			session_.replicate(object, replicationMode);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#save(java.lang.Object)
	 */
	public Serializable save(Object object) throws HibernateRuntimeException {
		try {
			return session_.save(object);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#save(java.lang.Object, java.io.Serializable)
	 */
	public void save(Object object, Serializable id)
		throws HibernateRuntimeException {

		try {
			session_.save(object, id);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#saveOrUpdate(java.lang.Object)
	 */
	public void saveOrUpdate(Object object) throws HibernateRuntimeException {
		try {
			session_.saveOrUpdateCopy(object);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#update(java.lang.Object)
	 */
	public void update(Object object) throws HibernateRuntimeException {
		try {
			session_.update(object);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#update(java.lang.Object, java.io.Serializable)
	 */
	public void update(Object object, Serializable id)
		throws HibernateRuntimeException {

		try {
			session_.update(object, id);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#saveOrUpdateCopy(java.lang.Object)
	 */
	public Object saveOrUpdateCopy(Object object)
		throws HibernateRuntimeException {

		try {
			return session_.saveOrUpdateCopy(object);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#saveOrUpdateCopy(java.lang.Object, java.io.Serializable)
	 */
	public Object saveOrUpdateCopy(Object object, Serializable id)
		throws HibernateRuntimeException {

		try {
			return session_.saveOrUpdateCopy(object, id);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#delete(java.lang.Object)
	 */
	public void delete(Object object) throws HibernateRuntimeException {
		try {
			session_.delete(object);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#find(java.lang.String)
	 */
	public List find(String query) throws HibernateRuntimeException {
		try {
			return session_.find(query);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#find(java.lang.String, java.lang.Object, net.sf.hibernate.type.Type)
	 */
	public List find(String query, Object value, Type type)
		throws HibernateRuntimeException {

		try {
			return session_.find(query, value, type);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#find(java.lang.String, java.lang.Object[], net.sf.hibernate.type.Type[])
	 */
	public List find(String query, Object[] values, Type[] types)
		throws HibernateRuntimeException {

		try {
			return session_.find(query, values, types);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#iterate(java.lang.String)
	 */
	public Iterator iterate(String query) throws HibernateRuntimeException {
		try {
			return session_.iterate(query);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#iterate(java.lang.String, java.lang.Object, net.sf.hibernate.type.Type)
	 */
	public Iterator iterate(String query, Object value, Type type)
		throws HibernateRuntimeException {

		try {
			return session_.iterate(query, value, type);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#iterate(java.lang.String, java.lang.Object[], net.sf.hibernate.type.Type[])
	 */
	public Iterator iterate(String query, Object[] values, Type[] types)
		throws HibernateRuntimeException {

		try {
			return session_.iterate(query, values, types);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#filter(java.lang.Object, java.lang.String)
	 */
	public Collection filter(Object collection, String filter)
		throws HibernateRuntimeException {

		try {
			return session_.filter(collection, filter);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#filter(java.lang.Object, java.lang.String, java.lang.Object, net.sf.hibernate.type.Type)
	 */
	public Collection filter(
		Object collection,
		String filter,
		Object value,
		Type type)
		throws HibernateRuntimeException {

		try {
			return session_.filter(collection, filter, value, type);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#filter(java.lang.Object, java.lang.String, java.lang.Object[], net.sf.hibernate.type.Type[])
	 */
	public Collection filter(
		Object collection,
		String filter,
		Object[] values,
		Type[] types)
		throws HibernateRuntimeException {

		try {
			return session_.filter(collection, filter, values, types);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#delete(java.lang.String)
	 */
	public int delete(String query) throws HibernateRuntimeException {
		try {
			return session_.delete(query);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#delete(java.lang.String, java.lang.Object, net.sf.hibernate.type.Type)
	 */
	public int delete(String query, Object value, Type type)
		throws HibernateRuntimeException {

		try {
			return session_.delete(query, value, type);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#delete(java.lang.String, java.lang.Object[], net.sf.hibernate.type.Type[])
	 */
	public int delete(String query, Object[] values, Type[] types)
		throws HibernateRuntimeException {

		try {
			return session_.delete(query, values, types);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#lock(java.lang.Object, net.sf.hibernate.LockMode)
	 */
	public void lock(Object object, LockMode lockMode)
		throws HibernateRuntimeException {

		try {
			session_.lock(object, lockMode);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#refresh(java.lang.Object)
	 */
	public void refresh(Object object) throws HibernateRuntimeException {
		try {
			session_.refresh(object);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#refresh(java.lang.Object, net.sf.hibernate.LockMode)
	 */
	public void refresh(Object object, LockMode lockMode)
		throws HibernateRuntimeException {

		try {
			session_.refresh(object, lockMode);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#getCurrentLockMode(java.lang.Object)
	 */
	public LockMode getCurrentLockMode(Object object)
		throws HibernateRuntimeException {

		try {
			return session_.getCurrentLockMode(object);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#beginTransaction()
	 */
	public Transaction beginTransaction() throws HibernateRuntimeException {
		try {
			return session_.beginTransaction();
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#createCriteria(java.lang.Class)
	 */
	public Criteria createCriteria(Class persistentClass) {
		return session_.createCriteria(persistentClass);
	}

	/**
	 * @see org.seasar.hibernate.S2Session#createQuery(java.lang.String)
	 */
	public Query createQuery(String queryString)
		throws HibernateRuntimeException {

		try {
			return session_.createQuery(queryString);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#createFilter(java.lang.Object, java.lang.String)
	 */
	public Query createFilter(Object collection, String queryString)
		throws HibernateRuntimeException {

		try {
			return session_.createFilter(collection, queryString);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#getNamedQuery(java.lang.String)
	 */
	public Query getNamedQuery(String queryName)
		throws HibernateRuntimeException {

		try {
			return session_.getNamedQuery(queryName);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#createSQLQuery(java.lang.String, java.lang.String, java.lang.Class)
	 */
	public Query createSQLQuery(
		String sql,
		String returnAlias,
		Class returnClass) {

		return session_.createSQLQuery(sql, returnAlias, returnClass);
	}

	/**
	 * @see org.seasar.hibernate.S2Session#createSQLQuery(java.lang.String, java.lang.String[], java.lang.Class[])
	 */
	public Query createSQLQuery(
		String sql,
		String[] returnAliases,
		Class[] returnClasses) {

		return session_.createSQLQuery(sql, returnAliases, returnClasses);
	}

	/**
	 * @see org.seasar.hibernate.S2Session#clear()
	 */
	public void clear() {
		session_.clear();
	}

	/**
	 * @see org.seasar.hibernate.S2Session#get(java.lang.Class, java.io.Serializable)
	 */
	public Object get(Class clazz, Serializable id)
		throws HibernateRuntimeException {

		try {
			return session_.get(clazz, id);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}

	/**
	 * @see org.seasar.hibernate.S2Session#get(java.lang.Class, java.io.Serializable, net.sf.hibernate.LockMode)
	 */
	public Object get(Class clazz, Serializable id, LockMode lockMode)
		throws HibernateRuntimeException {

		try {
			return session_.get(clazz, id, lockMode);
		} catch (HibernateException ex) {
			throw new HibernateRuntimeException(ex);
		}
	}
}
