package org.seasar.extension.jdbc.impl;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class BeanPropertyHandler extends AbstractPropertyHandler {

	private Class beanClass_;
	
	public BeanPropertyHandler(Class beanClass) {
		beanClass_ = beanClass;
	}
	
	public Class getBeanClass() {
		return beanClass_;
	}

	public PropertyType[] createPropertyTypes(ResultSetMetaData rsmd)
		throws SQLException {

		int count = rsmd.getColumnCount();
		PropertyType[] propertyTypes = new PropertyType[count];
		BeanDesc beanDesc = BeanDescFactory.getBeanDesc(beanClass_);
		for (int i = 0; i < count; ++i) {
			String propertyName = getPropertyName(rsmd, i + 1);
			PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
			ValueType valueType = ValueTypes.getValueType(pd.getPropertyType());
			propertyTypes[i] =
				new PropertyTypeImpl(propertyName, valueType);
		}
		return propertyTypes;

	}
}
