package org.seasar.extension.jdbc.impl;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.seasar.extension.jdbc.PropertyHandler;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractPropertyHandler implements PropertyHandler {

	public AbstractPropertyHandler() {
	}
	
	protected String getPropertyName(ResultSetMetaData rsmd, int index)
		throws SQLException {
		
		String propertyName = rsmd.getColumnLabel(index);
		return convertPropertyName(propertyName);
	}

	protected String convertPropertyName(String propertyName) {
		return StringUtil.replace(propertyName, "_", "");
	}
}
