/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.groovy;

import groovy.lang.Closure;
import groovy.util.BuilderSupport;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.MethodDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.impl.SimpleComponentDef;
import org.seasar.framework.util.StringUtil;
import org.seasar.groovy.ClosureAroundAdvice;
import org.seasar.groovy.SeasarBuilderException;

public class SeasarBuilder
extends BuilderSupport {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$seasar$groovy$SeasarBuilder == null ? (class$org$seasar$groovy$SeasarBuilder = SeasarBuilder.class$("org.seasar.groovy.SeasarBuilder")) : class$org$seasar$groovy$SeasarBuilder));
    static /* synthetic */ Class class$org$seasar$groovy$SeasarBuilder;

    protected void setParent(Object object, Object object2) {
    }

    protected Object createNode(Object object) {
        if (object.equals("container") || object.equals("components")) {
            logger.debug((Object)"Create S2Container.");
            return new S2ContainerImpl();
        }
        if (object.equals("arg")) {
            logger.debug((Object)"Create ArgDef.");
            return new ArgDefImpl();
        }
        throw new SeasarBuilderException("Unknown markup; " + object);
    }

    protected Object createNode(Object object, Map map) {
        if (object.equals("component")) {
            logger.debug((Object)("Create ComponentDef with attributes; " + map));
            return this.setupComponentDef(map);
        }
        if (object.equals("prop")) {
            logger.debug((Object)("Create PropertyDef with attributes; " + map));
            return this.setupPropertyDef(map);
        }
        if (object.equals("arg")) {
            logger.debug((Object)("Create ArgDef with attributes; " + map));
            return this.setupArgDef(map);
        }
        if (object.equals("aspect")) {
            logger.debug((Object)("Create AspectDef with attributes; " + map));
            return this.setupAspectDef(map);
        }
        throw new SeasarBuilderException("Unknown markup; " + object + " with attributes; " + map);
    }

    protected Object createNode(Object object, Object object2) {
        if (object.equals("container") || object.equals("components")) {
            logger.debug((Object)("Create S2Container with namespace `" + object2 + "'."));
            S2ContainerImpl s2ContainerImpl = new S2ContainerImpl();
            s2ContainerImpl.setNamespace((String)object2);
            return s2ContainerImpl;
        }
        if (object.equals("component")) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (object2 instanceof Class) {
                hashMap.put("class", object2);
            } else {
                hashMap.put("obj", object2);
            }
            return this.createNode(object, hashMap);
        }
        if (object.equals("arg")) {
            logger.debug((Object)("Create ArgDef with value; " + object2));
            return new ArgDefImpl(object2);
        }
        if (object.equals("init")) {
            logger.debug((Object)("Create InitMethodDef with value; " + object2));
            return new InitMethodDefImpl((String)object2);
        }
        if (object.equals("destroy")) {
            logger.debug((Object)("Create DestroyDef with value; " + object2));
            return new DestroyMethodDefImpl((String)object2);
        }
        if (object.equals("include")) {
            if (this.getCurrent() == null) {
                throw new SeasarBuilderException("S2Container#include() is not defined.");
            }
            logger.debug((Object)("Include " + object2));
            return S2ContainerFactory.create((String)((String)object2));
        }
        throw new SeasarBuilderException("Unknown markup; " + object + " with value; " + object2);
    }

    protected void nodeCompleted(Object object, Object object2) {
        if (object == null && object2 instanceof S2Container) {
            return;
        }
        if (object instanceof S2Container) {
            this.setChildToS2Container((S2Container)object, object2);
            return;
        }
        if (object instanceof ComponentDef) {
            this.setChildToComponent((ComponentDef)object, object2);
            return;
        }
        if (object instanceof ArgDef) {
            this.setChildToArg((ArgDef)object, object2);
            return;
        }
        if (object instanceof MethodDef) {
            this.setChildToMethod((MethodDef)object, object2);
            return;
        }
        throw new SeasarBuilderException(object + " can't be parent of " + object2);
    }

    private void setChildToArg(ArgDef argDef, Object object) {
        if (!(object instanceof ComponentDef)) {
            throw new SeasarBuilderException("ArgDef can't be parent of " + object);
        }
        logger.debug((Object)("Setting " + object + " as child component for " + argDef));
        argDef.setChildComponentDef((ComponentDef)object);
    }

    private void setChildToComponent(ComponentDef componentDef, Object object) {
        if (object instanceof PropertyDef) {
            logger.debug((Object)("Adding " + object + " as PropertyDef to " + componentDef));
            componentDef.addPropertyDef((PropertyDef)object);
        } else if (object instanceof AspectDef) {
            logger.debug((Object)("Adding " + object + " as AspectDef to " + componentDef));
            componentDef.addAspectDef((AspectDef)object);
        } else if (object instanceof ArgDef) {
            logger.debug((Object)("Adding " + object + " as ArgDef to " + componentDef));
            componentDef.addArgDef((ArgDef)object);
        } else if (object instanceof InitMethodDef) {
            logger.debug((Object)("Adding " + object + " as InitMethodDef to " + componentDef));
            componentDef.addInitMethodDef((InitMethodDef)object);
        } else if (object instanceof DestroyMethodDef) {
            logger.debug((Object)("Adding " + object + " as DestroyMethod to " + componentDef));
            componentDef.addDestroyMethodDef((DestroyMethodDef)object);
        } else {
            throw new SeasarBuilderException("ComponentDef can't be parent of " + object);
        }
    }

    private void setChildToMethod(MethodDef methodDef, Object object) {
        if (!(object instanceof ArgDef)) {
            throw new SeasarBuilderException("MethodDef can't be parent of " + object);
        }
        logger.debug((Object)("Adding " + object + " as ArgDef to " + methodDef));
        methodDef.addArgDef((ArgDef)object);
    }

    private void setChildToS2Container(S2Container s2Container, Object object) {
        if (object instanceof ComponentDef) {
            logger.debug((Object)("Registering " + object + " as ComponentDef to " + s2Container));
            s2Container.register((ComponentDef)object);
        } else if (object instanceof S2Container) {
            logger.debug((Object)("Including " + object + " to " + s2Container));
            s2Container.include((S2Container)object);
        } else {
            throw new SeasarBuilderException("S2Container can't be parent of " + object);
        }
    }

    private ArgDef setupArgDef(Map map) {
        String string = (String)map.get("ref");
        ArgDefImpl argDefImpl = new ArgDefImpl();
        argDefImpl.setExpression(string);
        return argDefImpl;
    }

    private AspectDef setupAspectDef(Map map) {
        AspectDefImpl aspectDefImpl = null;
        String string = (String)map.get("pointcut");
        if (map.get("advice") instanceof String) {
            if (string != null) {
                PointcutImpl pointcutImpl = new PointcutImpl(StringUtil.split((String)string, (String)","));
                aspectDefImpl = new AspectDefImpl((Pointcut)pointcutImpl);
            } else {
                aspectDefImpl = new AspectDefImpl();
            }
            aspectDefImpl.setExpression((String)map.get("advice"));
        } else if (map.get("advice") instanceof Closure) {
            ClosureAroundAdvice closureAroundAdvice = new ClosureAroundAdvice((Closure)map.get("advice"));
            if (string != null) {
                PointcutImpl pointcutImpl = new PointcutImpl(StringUtil.split((String)string, (String)","));
                aspectDefImpl = new AspectDefImpl((MethodInterceptor)closureAroundAdvice, (Pointcut)pointcutImpl);
            } else {
                aspectDefImpl = new AspectDefImpl((MethodInterceptor)closureAroundAdvice);
            }
        } else {
            throw new SeasarBuilderException("'advice' must be an expression string or a closure.");
        }
        return aspectDefImpl;
    }

    private ComponentDef setupComponentDef(Map map) {
        Object object = null;
        Class clazz = (Class)map.get("class");
        Object v = map.get("obj");
        String string = (String)map.get("name");
        String string2 = (String)map.get("destroy");
        String string3 = (String)map.get("instance");
        String string4 = (String)map.get("binding");
        if (clazz == null && v == null) {
            throw new SeasarBuilderException("Neither class nor object is pass, or null?");
        }
        object = string != null ? (clazz != null ? new ComponentDefImpl(clazz, string) : new SimpleComponentDef(v, string)) : (clazz != null ? new ComponentDefImpl(clazz) : new SimpleComponentDef(v));
        if (string3 != null) {
            object.setInstanceMode(string3);
        }
        if (string4 != null) {
            object.setAutoBindingMode(string4);
        }
        return object;
    }

    private PropertyDef setupPropertyDef(Map map) {
        boolean bl;
        String string = (String)map.get("name");
        Object v = map.get("value");
        String string2 = (String)map.get("ref");
        boolean bl2 = v != null;
        boolean bl3 = bl = string2 != null;
        if (bl2 && bl) {
            throw new SeasarBuilderException("'value' and 'ref' on 'prop' is mutually exclusive parameter.");
        }
        if (bl2) {
            return new PropertyDefImpl(string, v);
        }
        if (bl) {
            PropertyDefImpl propertyDefImpl = new PropertyDefImpl(string);
            propertyDefImpl.setExpression(string2);
            return propertyDefImpl;
        }
        throw new SeasarBuilderException("'value' or 'ref' must be set.");
    }

    protected Object createNode(Object object, Map map, Object object2) {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

