/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Binding;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.ObjectRange;
import groovy.lang.Script;
import groovy.lang.Tuple;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.Invoker;

public class InvokerHelper {
    public static final Object[] EMPTY_ARGS = new Object[0];
    private static final Object[] EMPTY_MAIN_ARGS = new Object[]{new String[0]};
    private static final Invoker singleton = new Invoker();
    private static final Integer ZERO = new Integer(0);
    private static final Integer MINUS_ONE = new Integer(-1);
    private static final Integer ONE = new Integer(1);

    public static MetaClass getMetaClass(Object object) {
        return InvokerHelper.getInstance().getMetaClass(object);
    }

    public static Invoker getInstance() {
        return singleton;
    }

    public static Object invokeNoArgumentsMethod(Object object, String methodName) {
        return InvokerHelper.getInstance().invokeMethod(object, methodName, EMPTY_ARGS);
    }

    public static Object invokeMethod(Object object, String methodName, Object arguments) {
        return InvokerHelper.getInstance().invokeMethod(object, methodName, arguments);
    }

    public static Object invokeSuperMethod(Object object, String methodName, Object arguments) {
        return InvokerHelper.getInstance().invokeSuperMethod(object, methodName, arguments);
    }

    public static Object invokeMethodSafe(Object object, String methodName, Object arguments) {
        if (object != null) {
            return InvokerHelper.getInstance().invokeMethod(object, methodName, arguments);
        }
        return null;
    }

    public static Object invokeStaticMethod(String type, String methodName, Object arguments) {
        return InvokerHelper.getInstance().invokeStaticMethod(type, methodName, arguments);
    }

    public static Object invokeStaticNoArgumentsMethod(String type, String methodName) {
        return InvokerHelper.getInstance().invokeStaticMethod(type, methodName, EMPTY_ARGS);
    }

    public static Object invokeConstructor(String type, Object arguments) {
        return InvokerHelper.getInstance().invokeConstructor(type, arguments);
    }

    public static Object invokeConstructorOf(Class type, Object arguments) {
        return InvokerHelper.getInstance().invokeConstructorOf(type, arguments);
    }

    public static Object invokeNoArgumentsConstructorOf(Class type) {
        return InvokerHelper.getInstance().invokeConstructorOf(type, EMPTY_ARGS);
    }

    public static Object invokeClosure(Object closure, Object arguments) {
        return InvokerHelper.getInstance().invokeMethod(closure, "doCall", arguments);
    }

    public static Iterator asIterator(Object collection) {
        return InvokerHelper.getInstance().asIterator(collection);
    }

    public static Collection asCollection(Object collection) {
        return InvokerHelper.getInstance().asCollection(collection);
    }

    public static List asList(Object args) {
        return InvokerHelper.getInstance().asList(args);
    }

    public static String toString(Object arguments) {
        return InvokerHelper.getInstance().toString(arguments);
    }

    public static String toTypeString(Object[] arguments) {
        return InvokerHelper.getInstance().toTypeString(arguments);
    }

    public static String inspect(Object self) {
        return InvokerHelper.getInstance().inspect(self);
    }

    public static Object getProperty(Object object, String property) {
        return InvokerHelper.getInstance().getProperty(object, property);
    }

    public static Object getPropertySafe(Object object, String property) {
        if (object != null) {
            return InvokerHelper.getInstance().getProperty(object, property);
        }
        return null;
    }

    public static void setProperty(Object object, String property, Object newValue) {
        InvokerHelper.getInstance().setProperty(object, property, newValue);
    }

    public static void setProperty2(Object newValue, Object object, String property) {
        InvokerHelper.getInstance().setProperty(object, property, newValue);
    }

    public static void setGroovyObjectProperty(Object newValue, GroovyObject object, String property) {
        object.setProperty(property, newValue);
    }

    public static Object getGroovyObjectProperty(GroovyObject object, String property) {
        return object.getProperty(property);
    }

    public static void setPropertySafe2(Object newValue, Object object, String property) {
        if (object != null) {
            InvokerHelper.setProperty2(newValue, object, property);
        }
    }

    public static Object asType(Object object, Class type) {
        return InvokerHelper.getInstance().asType(object, type);
    }

    public static boolean asBool(Object object) {
        return InvokerHelper.getInstance().asBool(object);
    }

    public static boolean notObject(Object object) {
        return !InvokerHelper.asBool(object);
    }

    public static boolean notBoolean(boolean bool) {
        return !bool;
    }

    public static Object negate(Object value) {
        if (value instanceof Integer) {
            Integer number = (Integer)value;
            return new Integer(-number.intValue());
        }
        if (value instanceof Long) {
            Long number = (Long)value;
            return new Long(-number.longValue());
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).negate();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).negate();
        }
        if (value instanceof Double) {
            Double number = (Double)value;
            return new Double(-number.doubleValue());
        }
        if (value instanceof Float) {
            Float number = (Float)value;
            return new Float(-number.floatValue());
        }
        throw new GroovyRuntimeException("Cannot negate type " + value.getClass().getName() + ", value " + value);
    }

    public static boolean isCase(Object switchValue, Object caseExpression) {
        return InvokerHelper.asBool(InvokerHelper.invokeMethod(caseExpression, "isCase", new Object[]{switchValue}));
    }

    public static boolean compareIdentical(Object left, Object right) {
        return left == right;
    }

    public static boolean compareEqual(Object left, Object right) {
        return InvokerHelper.getInstance().objectsEqual(left, right);
    }

    public static Matcher findRegex(Object left, Object right) {
        return InvokerHelper.getInstance().objectFindRegex(left, right);
    }

    public static boolean matchRegex(Object left, Object right) {
        return InvokerHelper.getInstance().objectMatchRegex(left, right);
    }

    public static Pattern regexPattern(String regex) {
        return InvokerHelper.getInstance().regexPattern(regex);
    }

    public static boolean compareNotEqual(Object left, Object right) {
        return !InvokerHelper.getInstance().objectsEqual(left, right);
    }

    public static boolean compareLessThan(Object left, Object right) {
        return InvokerHelper.getInstance().compareTo(left, right) < 0;
    }

    public static boolean compareLessThanEqual(Object left, Object right) {
        return InvokerHelper.getInstance().compareTo(left, right) <= 0;
    }

    public static boolean compareGreaterThan(Object left, Object right) {
        return InvokerHelper.getInstance().compareTo(left, right) > 0;
    }

    public static boolean compareGreaterThanEqual(Object left, Object right) {
        return InvokerHelper.getInstance().compareTo(left, right) >= 0;
    }

    public static Integer compareTo(Object left, Object right) {
        int answer = InvokerHelper.getInstance().compareTo(left, right);
        if (answer == 0) {
            return ZERO;
        }
        return answer > 0 ? ONE : MINUS_ONE;
    }

    public static Tuple createTuple(Object[] array) {
        return new Tuple(array);
    }

    public static List createList(Object[] values) {
        ArrayList<Object> answer = new ArrayList<Object>(values.length);
        for (int i = 0; i < values.length; ++i) {
            answer.add(values[i]);
        }
        return answer;
    }

    public static Map createMap(Object[] values) {
        HashMap<Object, Object> answer = new HashMap<Object, Object>(values.length / 2);
        int i = 0;
        while (i < values.length) {
            answer.put(values[i++], values[i++]);
        }
        return answer;
    }

    public static List createRange(Object from, Object to, boolean inclusive) {
        if (!inclusive) {
            to = InvokerHelper.compareGreaterThan(from, to) ? InvokerHelper.invokeMethod(to, "next", EMPTY_ARGS) : InvokerHelper.invokeMethod(to, "previous", EMPTY_ARGS);
        }
        if (from instanceof Integer && to instanceof Integer) {
            return new IntRange(InvokerHelper.asInt(from), InvokerHelper.asInt(to));
        }
        return new ObjectRange((Comparable)from, (Comparable)to);
    }

    public static int asInt(Object value) {
        return InvokerHelper.getInstance().asInt(value);
    }

    public static void assertFailed(Object expression, Object message) {
        if (message == null || "".equals(message)) {
            throw new AssertionError((Object)("Expression: " + expression));
        }
        throw new AssertionError((Object)("" + message + ". Expression: " + expression));
    }

    public static Object runScript(Class scriptClass, String[] args) {
        Binding context = new Binding(args);
        Script script = InvokerHelper.createScript(scriptClass, context);
        return InvokerHelper.invokeMethod(script, "run", EMPTY_ARGS);
    }

    public static Script createScript(Class scriptClass, Binding context) {
        try {
            final GroovyObject object = (GroovyObject)scriptClass.newInstance();
            Script script = null;
            if (object instanceof Script) {
                script = (Script)object;
            } else {
                script = new Script(){

                    public Object run() {
                        object.invokeMethod("main", EMPTY_MAIN_ARGS);
                        return null;
                    }
                };
                InvokerHelper.setProperties(object, context.getVariables());
            }
            script.setBinding(context);
            return script;
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Failed to create Script instance for class: " + scriptClass + ". Reason: " + e, e);
        }
    }

    public static void setProperties(Object object, Map map) {
        InvokerHelper.getMetaClass(object).setProperties(object, map);
    }

    public static String getVersion() {
        String version = null;
        Package p = Package.getPackage("groovy.lang");
        if (p != null) {
            version = p.getImplementationVersion();
        }
        if (version == null) {
            version = "";
        }
        return version;
    }

    protected static List primitiveArrayToList(Object array) {
        int size = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    public static void write(Writer out, Object object) throws IOException {
        if (object instanceof String) {
            out.write((String)object);
        } else if (object instanceof Writable) {
            Writable writable = (Writable)object;
            writable.writeTo(out);
        } else if (object instanceof InputStream || object instanceof Reader) {
            int i;
            Reader reader = object instanceof InputStream ? new InputStreamReader((InputStream)object) : (Reader)object;
            char[] chars = new char[8192];
            while ((i = reader.read(chars)) != -1) {
                out.write(chars, 0, i);
            }
            reader.close();
        } else {
            out.write(InvokerHelper.toString(object));
        }
    }

    public static Object box(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object box(byte value) {
        return new Byte(value);
    }

    public static Object box(char value) {
        return new Character(value);
    }

    public static Object box(short value) {
        return new Short(value);
    }

    public static Object box(int value) {
        return new Integer(value);
    }

    public static Object box(long value) {
        return new Long(value);
    }

    public static Object box(float value) {
        return new Float(value);
    }

    public static Object box(double value) {
        return new Double(value);
    }

    public static byte byteUnbox(Object value) {
        Number n = (Number)InvokerHelper.asType(value, Byte.class);
        return n.byteValue();
    }

    public static char charUnbox(Object value) {
        Character n = (Character)InvokerHelper.asType(value, Character.class);
        return n.charValue();
    }

    public static short shortUnbox(Object value) {
        Number n = (Number)InvokerHelper.asType(value, Short.class);
        return n.shortValue();
    }

    public static int intUnbox(Object value) {
        Number n = (Number)InvokerHelper.asType(value, Integer.class);
        return n.intValue();
    }

    public static boolean booleanUnbox(Object value) {
        Boolean n = (Boolean)InvokerHelper.asType(value, Boolean.class);
        return n;
    }

    public static long longUnbox(Object value) {
        Number n = (Number)InvokerHelper.asType(value, Long.class);
        return n.longValue();
    }

    public static float floatUnbox(Object value) {
        Number n = (Number)InvokerHelper.asType(value, Float.class);
        return n.floatValue();
    }

    public static double doubleUnbox(Object value) {
        Number n = (Number)InvokerHelper.asType(value, Double.class);
        return n.doubleValue();
    }
}

