/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.lang.reflect.Field;
import org.codehaus.groovy.ast.MetadataNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.objectweb.asm.Constants;

public class FieldNode
extends MetadataNode
implements Constants {
    private String name;
    private int modifiers;
    private String type;
    private String owner;
    private Expression initialValueExpression;
    private boolean dynamicType;
    private boolean holder;

    public static FieldNode newStatic(Class theClass, String name) throws SecurityException, NoSuchFieldException {
        Field field = theClass.getField(name);
        String type = field.getType().getName();
        return new FieldNode(name, 9, type, theClass.getName(), null);
    }

    public FieldNode(String name, int modifiers, String type, String owner, Expression initialValueExpression) {
        this.name = name;
        this.modifiers = modifiers;
        this.type = type;
        this.owner = owner;
        this.initialValueExpression = initialValueExpression;
        if (type == null) {
            this.type = "java.lang.Object";
            this.dynamicType = true;
        }
    }

    public Expression getInitialValueExpression() {
        return this.initialValueExpression;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isHolder() {
        return this.holder;
    }

    public void setHolder(boolean holder) {
        this.holder = holder;
    }

    public boolean isDynamicType() {
        return this.dynamicType;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }
}

