/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import java.beans.IntrospectionException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;

public class MetaClassRegistry {
    private Map metaClasses = Collections.synchronizedMap(new HashMap());
    private boolean useAccessible;
    private GroovyClassLoader loader = (GroovyClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new GroovyClassLoader(this.getClass().getClassLoader());
        }
    });

    public MetaClassRegistry() {
        this(true);
    }

    public MetaClassRegistry(boolean useAccessible) {
        this.useAccessible = useAccessible;
        this.lookup(DefaultGroovyMethods.class).registerInstanceMethods();
        this.lookup(DefaultGroovyStaticMethods.class).registerStaticMethods();
        this.checkInitialised();
    }

    public MetaClass getMetaClass(Class theClass) {
        MetaClass answer = (MetaClass)this.metaClasses.get(theClass);
        if (answer == null) {
            try {
                answer = new MetaClass(this, theClass);
                answer.checkInitialised();
            }
            catch (IntrospectionException e) {
                throw new GroovyRuntimeException("Could not introspect class: " + theClass.getName() + ". Reason: " + e, e);
            }
            this.metaClasses.put(theClass, answer);
        }
        return answer;
    }

    public void setMetaClass(Class theClass, MetaClass theMetaClass) {
        this.metaClasses.put(theClass, theMetaClass);
    }

    public boolean useAccessible() {
        return this.useAccessible;
    }

    public Class loadClass(final String name, final byte[] bytecode) throws ClassNotFoundException {
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MetaClassRegistry.this.loader.defineClass(name, bytecode, this.getClass().getProtectionDomain());
            }
        });
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }

    void checkInitialised() {
        ArrayList list = new ArrayList(this.metaClasses.values());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            MetaClass metaClass = (MetaClass)iter.next();
            metaClass.checkInitialised();
        }
    }

    MetaClass lookup(Class theClass) {
        MetaClass answer = (MetaClass)this.metaClasses.get(theClass);
        if (answer == null) {
            try {
                answer = new MetaClass(this, theClass);
            }
            catch (IntrospectionException e) {
                throw new GroovyRuntimeException("Could not introspect class: " + theClass.getName() + ". Reason: " + e, e);
            }
            this.metaClasses.put(theClass, answer);
        }
        return answer;
    }
}

