/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public final class TagHandlerContext {
    private static final Integer ONE = new Integer(1);
    private StringBuffer body_ = null;
    private StringBuffer characters_ = new StringBuffer();
    private Stack bodyStack_ = new Stack();
    private StringBuffer path_ = new StringBuffer();
    private StringBuffer detailPath_ = new StringBuffer();
    private String qName_ = "";
    private Stack qNameStack_ = new Stack();
    private Object result_;
    private Stack stack_ = new Stack();
    private Map pathCounts_ = new HashMap();

    public void push(Object o) {
        if (this.stack_.empty()) {
            this.result_ = o;
        }
        this.stack_.push(o);
    }

    public Object getResult() {
        return this.result_;
    }

    public Object pop() {
        return this.stack_.pop();
    }

    public Object peek() {
        return this.stack_.peek();
    }

    public Object peek(int n) {
        return this.stack_.get(this.stack_.size() - n - 1);
    }

    public Object peek(Class clazz) {
        int i = this.stack_.size() - 1;
        while (i >= 0) {
            Object o = this.stack_.get(i);
            if (clazz.isInstance(o)) {
                return o;
            }
            --i;
        }
        return null;
    }

    public Object peekFirst() {
        return this.stack_.get(0);
    }

    public void startElement(String qName) {
        this.bodyStack_.push(this.body_);
        this.body_ = new StringBuffer();
        this.characters_ = new StringBuffer();
        this.qNameStack_.push(this.qName_);
        this.qName_ = qName;
        this.path_.append("/");
        this.path_.append(qName);
        int pathCount = this.incrementPathCount();
        this.detailPath_.append("/");
        this.detailPath_.append(qName);
        this.detailPath_.append("[");
        this.detailPath_.append(pathCount);
        this.detailPath_.append("]");
    }

    public void characters(char[] buffer, int start, int length) {
        this.body_.append(buffer, start, length);
        this.characters_.append(buffer, start, length);
    }

    public String getCharacters() {
        return this.characters_.toString().trim();
    }

    public String getBody() {
        return this.body_.toString().trim();
    }

    public boolean isCharactersEol() {
        if (this.characters_.length() == 0) {
            return false;
        }
        return this.characters_.charAt(this.characters_.length() - 1) == '\n';
    }

    public void clearCharacters() {
        this.characters_ = new StringBuffer();
    }

    public void endElement() {
        this.body_ = (StringBuffer)this.bodyStack_.pop();
        TagHandlerContext.remoteLastPath(this.path_);
        TagHandlerContext.remoteLastPath(this.detailPath_);
        this.qName_ = (String)this.qNameStack_.pop();
    }

    private static void remoteLastPath(StringBuffer path) {
        path.delete(path.lastIndexOf("/"), path.length());
    }

    public String getPath() {
        return this.path_.toString();
    }

    public String getDetailPath() {
        return this.detailPath_.toString();
    }

    public String getQName() {
        return this.qName_;
    }

    private int incrementPathCount() {
        String path = this.getPath();
        Integer pathCount = (Integer)this.pathCounts_.get(path);
        pathCount = pathCount == null ? ONE : new Integer(pathCount + 1);
        this.pathCounts_.put(path, pathCount);
        return pathCount;
    }
}

