/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AbstractPropertyAssembler;
import org.seasar.framework.container.util.AutoBindingUtil;
import org.seasar.framework.message.MessageFormatter;

public class AutoPropertyAssembler
extends AbstractPropertyAssembler {
    public AutoPropertyAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    public void assemble(Object component) {
        BeanDesc beanDesc = this.getBeanDesc(component);
        S2Container container = this.getComponentDef().getContainer();
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            block6: {
                Object value = null;
                PropertyDesc propDesc = beanDesc.getPropertyDesc(i);
                String propName = propDesc.getPropertyName();
                if (this.getComponentDef().hasPropertyDef(propName)) {
                    PropertyDef propDef = this.getComponentDef().getPropertyDef(propName);
                    value = this.getValue(propDef, component);
                    this.setValue(propDesc, component, value);
                } else if (propDesc.getWriteMethod() != null && AutoBindingUtil.isSuitable(propDesc.getPropertyType())) {
                    try {
                        value = container.getComponent(propDesc.getPropertyType());
                    }
                    catch (ComponentNotFoundRuntimeException cause) {
                        String message = MessageFormatter.getMessage("WSSR0008", new Object[]{this.getComponentClass(component).getName(), propName});
                        System.out.println(message);
                        break block6;
                    }
                    this.setValue(propDesc, component, value);
                }
            }
            ++i;
        }
    }
}

