/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.IllegalMethodRuntimeException;
import org.seasar.framework.container.MethodDef;
import org.seasar.framework.container.assembler.AbstractAssembler;
import org.seasar.framework.container.assembler.MethodAssembler;
import org.seasar.framework.container.util.AutoBindingUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.OgnlUtil;

public abstract class AbstractMethodAssembler
extends AbstractAssembler
implements MethodAssembler {
    public AbstractMethodAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    protected void invoke(BeanDesc beanDesc, Object component, MethodDef methodDef) throws IllegalMethodRuntimeException {
        String expression = methodDef.getExpression();
        String methodName = methodDef.getMethodName();
        if (methodName != null) {
            Object[] args = null;
            Method method = null;
            try {
                if (methodDef.getArgDefSize() > 0) {
                    args = methodDef.getArgs();
                } else {
                    Method[] methods = beanDesc.getMethods(methodName);
                    method = this.getSuitableMethod(methods);
                    if (method != null) {
                        args = this.getArgs(method.getParameterTypes());
                    }
                }
            }
            catch (ComponentNotFoundRuntimeException cause) {
                throw new IllegalMethodRuntimeException(this.getComponentClass(component), methodName, (Throwable)cause);
            }
            if (method != null) {
                MethodUtil.invoke(method, component, args);
            } else {
                this.invoke(beanDesc, component, methodName, args);
            }
        } else {
            this.invokeExpression(component, expression);
        }
    }

    private void invokeExpression(Object component, String expression) {
        Object exp = OgnlUtil.parseExpression(expression);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("self", component);
        ctx.put("out", System.out);
        ctx.put("err", System.err);
        OgnlUtil.getValue(exp, ctx, this.getComponentDef().getContainer());
    }

    private Method getSuitableMethod(Method[] methods) {
        int argSize = -1;
        Method method = null;
        int i = 0;
        while (i < methods.length) {
            int tempArgSize = methods[i].getParameterTypes().length;
            if (tempArgSize > argSize && AutoBindingUtil.isSuitable(methods[i].getParameterTypes())) {
                method = methods[i];
                argSize = tempArgSize;
            }
            ++i;
        }
        return method;
    }

    private void invoke(BeanDesc beanDesc, Object component, String methodName, Object[] args) throws IllegalMethodRuntimeException {
        try {
            beanDesc.invoke(component, methodName, args);
        }
        catch (NumberFormatException ex) {
            throw new IllegalMethodRuntimeException(this.getComponentDef().getComponentClass(), methodName, (Throwable)ex);
        }
    }

    public abstract void assemble(Object var1) throws IllegalMethodRuntimeException;
}

