/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TraceInterceptor
implements MethodInterceptor {
    private static final String CGLIB_PATTERN = "$$EnhancerByCGLIB$$";

    public Object invoke(MethodInvocation invocation) throws Throwable {
        StringBuffer buf = new StringBuffer(100);
        buf.append(TraceInterceptor.getClassName(invocation.getThis().getClass()));
        buf.append("#");
        buf.append(invocation.getMethod().getName());
        buf.append("(");
        Object[] args = invocation.getArguments();
        if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                buf.append(args[i]);
                buf.append(", ");
                ++i;
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        System.out.println("BEGIN " + buf);
        try {
            try {
                Object ret = invocation.proceed();
                buf.append(" : ");
                buf.append(ret);
                Object object = ret;
                Object var5_8 = null;
                System.out.println("END " + buf);
                return object;
            }
            catch (Throwable t) {
                buf.append(" Throwable:");
                buf.append(t);
                throw t;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            System.out.println("END " + buf);
            throw throwable;
        }
    }

    private static String getClassName(Class clazz) {
        String className = clazz.getName();
        int pos = className.indexOf(CGLIB_PATTERN);
        if (pos > -1) {
            return className.substring(1, pos);
        }
        return className;
    }
}

