package org.seasar.tapestry;

import java.util.Map;

import ognl.ObjectPropertyAccessor;
import ognl.OgnlException;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/**
 * @author higa
 *
 */
public class GlobalProxyPropertyAccessor extends ObjectPropertyAccessor {

	public Object getProperty(Map cx, Object target, Object name)
		throws OgnlException {

		GlobalProxy proxy = (GlobalProxy) target;
		S2Container container = SingletonS2ContainerFactory.getContainer();
		String componentName = name.toString();
		if (container.hasComponentDef(componentName)) {
			return container.getComponent(componentName);
		} else {
			return super.getProperty(cx, proxy.getGlobal(), name);
		}
	}

}
