package org.seasar.framework.aop.interceptors;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

/**
 * @author higa
 *
 */
public class TraceInterceptor implements MethodInterceptor {
	
	private static final String CGLIB_PATTERN = "$$EnhancerByCGLIB$$";

	public Object invoke(MethodInvocation invocation) throws Throwable {
		StringBuffer buf = new StringBuffer(100);
		buf.append(getClassName(invocation.getThis().getClass()));
		buf.append("#");
		buf.append(invocation.getMethod().getName());
		buf.append("(");
		Object[] args = invocation.getArguments(); 
		if (args != null && args.length > 0) { 
			for (int i = 0; i < args.length; ++i) {
				buf.append(args[i]);
				buf.append(", ");
			}
			buf.setLength(buf.length() - 2);
		}
		buf.append(")");
		System.out.println("BEGIN " + buf);
		try {
			Object ret = invocation.proceed();
			buf.append(" : ");
			buf.append(ret);
			return ret;
		} catch (Throwable t) {
			buf.append(" Throwable:");
			buf.append(t);
			throw t;
		} finally {
			System.out.println("END " + buf);
		}
	}

	private static String getClassName(Class clazz) {
		String className = clazz.getName();
		int pos = className.indexOf(CGLIB_PATTERN);
		if (pos > -1) {
			return className.substring(1, pos);
		} else {
			return className;
		}
	}
}
