package test.examples.ioc.service;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.S2ContainerImpl;

import examples.ioc.service.AutoNumber;
import examples.ioc.service.AutoNumberImpl;
import examples.ioc.service.NumberKeyNotFoundRuntimeException;
import junit.framework.TestCase;

public class AutoNumberImplTest extends TestCase {

	private AutoNumber autoNumber_;

	public AutoNumberImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(AutoNumberImplTest.class);
	}

	protected void setUp() throws Exception {
		S2Container container = new S2ContainerImpl();
		container.register(AutoNumberImpl.class);
		container.register(DummyAutoNumberDao.class);
		autoNumber_ = (AutoNumber) container.getComponent(AutoNumber.class);
	}

	public void testNext() {
		assertEquals("1", 1, autoNumber_.next(1));
		assertEquals("2", 2, autoNumber_.next(1));
	}

	public void testNextForNumberKeyNotFound() {
		try {
			autoNumber_.next(-1);
			fail("1");
		} catch (NumberKeyNotFoundRuntimeException ex) {
			assertEquals("2", -1, ex.getNumberKey());
		}
	}
}
