package org.seasar.framework.sel.exps;

import org.seasar.framework.util.StringConversionUtil;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class ToStringExp implements Expression {

	private Expression arg1Exp_;
	private String pattern_;

	public ToStringExp(Expression arg1Exp, String pattern) {
		arg1Exp_ = arg1Exp;
		pattern_ = pattern;
	}

	public Object evaluateValue(SelContext context) {
		Object arg1 = arg1Exp_.evaluateValue(context);
		return StringConversionUtil.toString(arg1, pattern_);
	}
}
