package org.seasar.framework.beans;

import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.MethodUtil;

/**
 * @author higa
 *
 * Ώۂ̃NXɓKp\ȃ\bhȂꍇ̎sOłB
 */
public final class MethodNotFoundRuntimeException extends SRuntimeException {

	private Class targetClass_;
	private String methodName_;
	private Object[] methodArgs_;

	/**
	 * @param targetClass
	 */
	public MethodNotFoundRuntimeException(Class targetClass, String methodName,
		Object[] methodArgs) {

		super("ESSR0049", new Object[]{targetClass.getName(),
			MethodUtil.getSignature(methodName, methodArgs)});
		targetClass_ = targetClass;
		methodName_ = methodName;
		methodArgs_ = methodArgs;
	}
	
	public Class getTargetClass() {
		return targetClass_;
	}

	public String getMethodName() {
		return methodName_;
	}
	
	public Object[] getMethodArgs() {
		return methodArgs_;
	}
	
}
