package test.org.seasar.framework.sel.exps;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.exps.ObjectExp;
import org.seasar.framework.sel.exps.StaticMethodExp;
import org.seasar.framework.sel.util.ExpressionUtil;

public class StaticMethodExpTest extends TestCase {

	public StaticMethodExpTest(String name) {
		super(name);
	}

	public static String foo(Object o) {
		return o.toString();
	}

	public void testEvaluateValue() throws Exception {
		List argExps = new ArrayList();
		argExps.add(new ObjectExp(new Integer(1)));
		Expression exp =
			new StaticMethodExp(
				String.class,
				"valueOf",
				ExpressionUtil.toExpressionArray(argExps));
		assertEquals("1", "1", exp.evaluateValue(null));
	}

	public void testEvaluateValue2() throws Exception {
		List argExps = new ArrayList();
		argExps.add(new ObjectExp(new Integer(4)));
		Expression exp =
			new StaticMethodExp(
				Math.class,
				"sqrt",
				ExpressionUtil.toExpressionArray(argExps));
		assertEquals("1", new Double(2.0), exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(StaticMethodExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { StaticMethodExpTest.class.getName()});
	}
}