package test.org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.boolexps.IsFalseExp;
import org.seasar.framework.sel.exps.BooleanExp;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class IsFalseExpTest extends TestCase {

	public IsFalseExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		BoolExpression exp = new IsFalseExp(BooleanExp.TRUE);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		BoolExpression exp = new IsFalseExp(BooleanExp.FALSE);
		assertEquals("1", true, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(IsFalseExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { IsFalseExpTest.class.getName()});
	}
}