package test.org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.boolexps.AndExp;
import org.seasar.framework.sel.boolexps.BoolExp;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class AndExpTest extends TestCase {

    public AndExpTest(String name) {
        super(name);
    }

	public void testEvaluate() throws Exception {
		BoolExpression exp = new AndExp(BoolExp.TRUE, BoolExp.TRUE);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		BoolExpression exp = new AndExp(BoolExp.TRUE, BoolExp.FALSE);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate3() throws Exception {
		BoolExpression exp = new AndExp(BoolExp.FALSE, BoolExp.TRUE);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate4() throws Exception {
		BoolExpression exp = new AndExp(BoolExp.FALSE, BoolExp.FALSE);
		assertEquals("1", false, exp.evaluate(null));
	}

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(AndExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{AndExpTest.class.getName()});
    }
}