package org.seasar.framework.util;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;


public final class ResourceUtil {

	private ResourceUtil() {
	}

	public static String getResourcePath(String path, String extension) {
		if (extension == null) {
			return path;
		}
		extension = "." + extension;
		if (path.endsWith(extension)) {
			return path;
		}
		return path.replace('.', '/') + extension;
	}
	
	public static String getResourcePath(Class clazz) {
		return clazz.getName().replace('.', '/') + ".class";
	}
	
	public static ClassLoader getClassLoader() {
		return Thread.currentThread().getContextClassLoader();
	}

	public static URL getResource(String path) {
		return getResource(path, null);
	}
	public static URL getResource(String path, String extension)
		throws ResourceNotFoundRuntimeException {

		path = getResourcePath(path, extension);
		URL url = getClassLoader().getResource(path);
		if (url != null) {
			return url;
		} else {
			throw new ResourceNotFoundRuntimeException(path);
		}
	}
	
	public static InputStream getResourceAsStream(String path) {
		return getResourceAsStream(path, null);
	}
		
	public static InputStream getResourceAsStream(String path, String extension) {
		URL url = getResource(path, extension);
		return URLUtil.openStream(url);
	}

	public static File getBuildDir(Class clazz) {
		URL url = getResource(getResourcePath(clazz));
		int num = StringUtil.split(clazz.getName(), ".").length;
		File file = new File(getFileName(url));
		for (int i = 0; i < num; ++i, file = file.getParentFile()) {
		}
		return file;
	}
	
	public static final String toExternalForm(URL url) {
		String s = url.toExternalForm();
		try {
			return URLDecoder.decode(s, "UTF8");
		} catch (UnsupportedEncodingException ex) {
			ex.printStackTrace();
			throw new RuntimeException(ex);
		}
	}
	
	public static final String getFileName(URL url) {
		String s = url.getFile();
		try {
			return URLDecoder.decode(s, "UTF8");
		} catch (UnsupportedEncodingException ex) {
			ex.printStackTrace();
			throw new RuntimeException(ex);
		}
	}
}