package org.seasar.framework.sel.exps;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public abstract class AbstractCalculateExp implements Expression {

	private Expression arg1Exp_;
	private Expression arg2Exp_;

	public AbstractCalculateExp(Expression arg1Exp, Expression arg2Exp) {
		arg1Exp_ = arg1Exp;
		arg2Exp_ = arg2Exp;
	}

	public final Number getArg1(SelContext context) {
		return (Number) arg1Exp_.evaluateValue(context);
	}

	public final Number getArg2(SelContext context) {
		return (Number) arg2Exp_.evaluateValue(context);
	}
}