package org.seasar.framework.container.factory;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.util.SAXParserFactoryUtil;
import org.seasar.framework.xml.SaxHandler;
import org.seasar.framework.xml.SaxHandlerParser;

/**
 * @author higa
 *
 */
public final class S2ContainerFactory {

	public static final String PUBLIC_ID = "-//SEASAR//DTD S2Container//EN";
	public static final String DTD_PATH =
		"org/seasar/framework/container/factory/components.dtd";
	private static S2ContainerTagHandlerRule rule_ =
		new S2ContainerTagHandlerRule();

	private S2ContainerFactory() {
	}

	public static S2Container create(String path) {
		SAXParserFactory factory = SAXParserFactoryUtil.newInstance();
		factory.setValidating(true);
		SAXParser saxParser = SAXParserFactoryUtil.newSAXParser(factory);
		SaxHandler handler = new SaxHandler(rule_);
		handler.registerDtdPath(PUBLIC_ID, DTD_PATH);
		SaxHandlerParser parser = new SaxHandlerParser(handler, saxParser);
		return (S2Container) parser.parse(path);
	}
}
