package org.seasar.extension.tx;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.seasar.framework.aop.Joinpoint;

/**
 * @author higa
 *
 */
public class RequiresNewAdvice extends AbstractTxAdvice {
	
	public RequiresNewAdvice(TransactionManager transactionManager) {
		super(transactionManager);
	}

	/**
	 * @see org.seasar.framework.aop.AroundAdvice#invoke(org.seasar.framework.aop.Joinpoint)
	 */
	public Object invoke(Joinpoint joinpoint) throws Throwable {
		Transaction tx = null;
		if (hasTransaction()) {
			tx = suspend();
		}
		Object ret = null;
		try {
			begin();
			try {
				ret = joinpoint.proceed();
				commit();
			} catch (Throwable t) {
				rollback();
				throw t;
			}
		} finally {
			if (tx != null) {
				resume(tx);
			}
		}
		return ret;
		
	}
}