package test.org.seasar.framework.sel.util;

import java.util.HashMap;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.TargetOfPropertyNotFoundRuntimeException;
import org.seasar.framework.sel.util.SelContextUtil;

public class SelContextUtilTest extends TestCase {

	public SelContextUtilTest(String name) {
		super(name);
	}

	public void testGetPropertyForMap() throws Exception {
		Map aaa = new HashMap();
		aaa.put("bbb", "hoge");
		assertEquals("1", "hoge", SelContextUtil.getProperty(aaa, "bbb"));
	}

	public void testGetPropertyForBean() throws Exception {
		Aaa aaa = new Aaa();
		assertEquals("1", "hoge", SelContextUtil.getProperty(aaa, "bbb"));
	}

	public void testGetPropertyForError() throws Exception {
		try {
			SelContextUtil.getProperty(null, "hoge");
		} catch (TargetOfPropertyNotFoundRuntimeException ex) {
			System.out.println(ex);
		}
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(SelContextUtilTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { SelContextUtilTest.class.getName()});
	}

	public static class Aaa {
		private String bbb_ = "hoge";

		public String getBbb() {
			return bbb_;
		}
	}
}