package test.org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.boolexps.BoolExp;
import org.seasar.framework.sel.boolexps.NotExp;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class NotExpTest extends TestCase {

	public NotExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		BoolExpression exp = new NotExp(BoolExp.TRUE);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		BoolExpression exp = new NotExp(BoolExp.FALSE);
		assertEquals("1", true, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(NotExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { NotExpTest.class.getName()});
	}
}