package test.org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.boolexps.GreaterThanExp;
import org.seasar.framework.sel.exps.ObjectExp;
import org.seasar.framework.sel.exps.NullExp;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class GreaterThanExpTest extends TestCase {

	public GreaterThanExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		String s = "1234567890";
		String s2 = "1234567891";
		Integer i = new Integer(s);
		Integer i2 = new Integer(s2);
		ObjectExp iExp = new ObjectExp(i);
		ObjectExp i2Exp = new ObjectExp(i2);
		GreaterThanExp gtExp = new GreaterThanExp(iExp, iExp);
		assertEquals("1", false, gtExp.evaluate(null));

		GreaterThanExp gt2Exp = new GreaterThanExp(i2Exp, iExp);
		assertEquals("2", true, gt2Exp.evaluate(null));

		GreaterThanExp gt3Exp = new GreaterThanExp(iExp, i2Exp);
		assertEquals("3", false, gt3Exp.evaluate(null));

		GreaterThanExp gt4Exp = new GreaterThanExp(iExp, NullExp.NULL);
		assertEquals("4", false, gt4Exp.evaluate(null));

		GreaterThanExp gt5Exp = new GreaterThanExp(NullExp.NULL, iExp);
		assertEquals("5", false, gt5Exp.evaluate(null));

		GreaterThanExp gt6Exp = new GreaterThanExp(NullExp.NULL, NullExp.NULL);
		assertEquals("6", false, gt6Exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(GreaterThanExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { GreaterThanExpTest.class.getName()});
	}
}