package test.org.seasar.framework.sel.boolexps;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.boolexps.BetweenExp;
import org.seasar.framework.sel.exps.NullExp;
import org.seasar.framework.sel.exps.ObjectExp;

public class BetweenExpTest extends TestCase {

	public BetweenExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		Expression arg1Exp = new ObjectExp(new Integer(5));
		Expression fromExp = new ObjectExp(new Integer(1));
		Expression toExp = new ObjectExp(new Integer(10));
		BetweenExp exp = new BetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		Expression arg1Exp = new ObjectExp(new Integer(1));
		Expression fromExp = new ObjectExp(new Integer(1));
		Expression toExp = new ObjectExp(new Integer(10));
		BetweenExp exp = new BetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate3() throws Exception {
		Expression arg1Exp = new ObjectExp(new Integer(10));
		Expression fromExp = new ObjectExp(new Integer(1));
		Expression toExp = new ObjectExp(new Integer(10));
		BetweenExp exp = new BetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate4() throws Exception {
		Expression arg1Exp = new ObjectExp(new Integer(0));
		Expression fromExp = new ObjectExp(new Integer(1));
		Expression toExp = new ObjectExp(new Integer(10));
		BetweenExp exp = new BetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate5() throws Exception {
		Expression arg1Exp = new ObjectExp(new Integer(11));
		Expression fromExp = new ObjectExp(new Integer(1));
		Expression toExp = new ObjectExp(new Integer(10));
		BetweenExp exp = new BetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate6() throws Exception {
		Expression arg1Exp = new ObjectExp(new Integer(1));
		Expression toExp = new ObjectExp(new Integer(10));
		BetweenExp exp = new BetweenExp(arg1Exp, NullExp.NULL, toExp);
		assertEquals("1", false, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(BetweenExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { BetweenExpTest.class.getName()});
	}
}