package org.seasar.framework.sel.exps;

import org.seasar.framework.util.StringConversionUtil;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class ConcatenateExp implements Expression {

	private Expression[] exps_;

	public ConcatenateExp(Expression[] exps) {
		exps_ = exps;
	}

	public Object evaluateValue(SelContext context) {
		StringBuffer buf = new StringBuffer(100);
		for (int i = 0; i < exps_.length; ++i) {
			String arg =
				StringConversionUtil.toString(exps_[i].evaluateValue(context));
			buf.append(arg);
		}
		return buf.toString();
	}
}
