package org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

abstract class AbstractCompareExp implements BoolExpression {

	private Expression arg1Exp_;
	private Expression arg2Exp_;

	public AbstractCompareExp(Expression arg1Exp, Expression arg2Exp) {
		arg1Exp_ = arg1Exp;
		arg2Exp_ = arg2Exp;
	}

	protected Comparable getArg1(SelContext context) {
		return (Comparable) arg1Exp_.evaluateValue(context);
	}

	protected Comparable getArg2(SelContext context) {
		return (Comparable) arg2Exp_.evaluateValue(context);
	}
}
