package org.seasar.framework.container.assembler;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.IllegalPropertyRuntimeException;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.PropertyNotFoundRuntimeException;

/**
 * @author higa
 *
 */
public class ManualPropertyAssembler extends AbstractPropertyAssembler {

	/**
	 * @param componentDef
	 */
	public ManualPropertyAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	public void assemble(Object component) {
		BeanDesc beanDesc = getBeanDesc();
		int size = getComponentDef().getPropertyDefSize();
		for (int i = 0; i < size; ++i) {
			PropertyDef propDef = getComponentDef().getPropertyDef(i);
			Object value = null;
			try {
				value = propDef.getValue();
			} catch (ComponentNotFoundRuntimeException cause) {
				throw new IllegalPropertyRuntimeException(
					getComponentDef().getComponentClass(),
					propDef.getPropertyName(),
					cause);
			}
			PropertyDesc propDesc =
				beanDesc.getPropertyDesc(propDef.getPropertyName());
			if (propDesc == null) {
				throw new PropertyNotFoundRuntimeException(
					getComponentDef().getComponentClass(),
					propDef.getPropertyName());
			}
			setValue(propDesc, component, value);
		}
	}

}
