package org.seasar.framework.container.assembler;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.IllegalMethodRuntimeException;

/**
 * @author higa
 *
 */
public abstract class AbstractMethodAssembler
	extends AbstractAssembler
	implements MethodAssembler {

	public AbstractMethodAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	protected void invoke(
		BeanDesc beanDesc,
		Object component,
		String methodName,
		Object[] args)
		throws IllegalMethodRuntimeException {

		try {
			beanDesc.invoke(component, methodName, args);
		} catch (NumberFormatException ex) {
			throw new IllegalMethodRuntimeException(
				getComponentDef().getComponentClass(),
				methodName,
				ex);
		}
	}
}
