package org.seasar.framework.beans.impl;

import java.lang.reflect.Method;

import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.DoubleConversionUtil;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.LongConversionUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.exception.EmptyRuntimeException;

public final class PropertyDescImpl implements PropertyDesc {

	private String propertyName_;
	private Class propertyType_;
	private Method readMethod_;
	private Method writeMethod_;
	
	public PropertyDescImpl(String propertyName, Class propertyType,
			Method readMethod, Method writeMethod) {
				
		if (propertyName == null) {
			throw new EmptyRuntimeException("propertyName");
		}
		if (propertyType == null) {
			throw new EmptyRuntimeException("propertyType");
		}
		
		propertyName_ = propertyName;
		propertyType_ = propertyType;
		readMethod_ = readMethod;
		writeMethod_ = writeMethod;
	}
	
	public final String getPropertyName() {
		return propertyName_;
	}

	public final Class getPropertyType() {
		return propertyType_;
	}
	
	public final Method getReadMethod() {
		return readMethod_;
	}
	
	public final void setReadMethod(Method readMethod) {
		readMethod_ = readMethod;
	}
	
	public final Method getWriteMethod() {
		return writeMethod_;
	}
	
	public final void setWriteMethod(Method writeMethod) {
		writeMethod_ = writeMethod;
	}
	
	public final Object getValue(Object target) {
		return MethodUtil.invoke(readMethod_, target, null);
	}
	
	public final void setValue(Object target, Object value) {
		MethodUtil.invoke(writeMethod_, target, new Object[]{
			convertIfNeed(propertyType_, value)});
	}
	
	public final String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("propertyName=");
		buf.append(propertyName_);
		buf.append(",propertyType=");
		buf.append(propertyType_.getName());
		buf.append(",readMethod=");
		buf.append(readMethod_ != null ?readMethod_.getName() : "null");
		buf.append(",writeMethod=");
		buf.append(writeMethod_ != null ?writeMethod_.getName() : "null");
		return buf.toString();
	}
	
	private static Object convertIfNeed(Class argType,Object arg) {
		if (argType.isPrimitive()) {
			if (argType == int.class) {
				return IntegerConversionUtil.toInteger(arg);
			} else if (argType == double.class) {
				return DoubleConversionUtil.toDouble(arg); 
			} else if (argType == long.class) {
				return LongConversionUtil.toLong(arg); 
			}
		}
		return arg;
	}
}
