package test.org.seasar.framework.sel.boolexps;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.boolexps.NotBetweenExp;
import org.seasar.framework.sel.exps.NullExp;
import org.seasar.framework.sel.exps.ObjectExp;

public class NotBetweenExpTest extends TestCase {

	public NotBetweenExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		ObjectExp arg1Exp = new ObjectExp(new Integer(5));
		ObjectExp fromExp = new ObjectExp(new Integer(1));
		ObjectExp toExp = new ObjectExp(new Integer(10));
		BoolExpression exp = new NotBetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		ObjectExp arg1Exp = new ObjectExp(new Integer(1));
		ObjectExp fromExp = new ObjectExp(new Integer(1));
		ObjectExp toExp = new ObjectExp(new Integer(10));
		BoolExpression exp = new NotBetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate3() throws Exception {
		ObjectExp arg1Exp = new ObjectExp(new Integer(10));
		ObjectExp fromExp = new ObjectExp(new Integer(1));
		ObjectExp toExp = new ObjectExp(new Integer(10));
		BoolExpression exp = new NotBetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", false, exp.evaluate(null));
	}

	public void testEvaluate4() throws Exception {
		ObjectExp arg1Exp = new ObjectExp(new Integer(0));
		ObjectExp fromExp = new ObjectExp(new Integer(1));
		ObjectExp toExp = new ObjectExp(new Integer(10));
		BoolExpression exp = new NotBetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate5() throws Exception {
		ObjectExp arg1Exp = new ObjectExp(new Integer(11));
		ObjectExp fromExp = new ObjectExp(new Integer(1));
		ObjectExp toExp = new ObjectExp(new Integer(10));
		BoolExpression exp = new NotBetweenExp(arg1Exp, fromExp, toExp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate6() throws Exception {
		ObjectExp arg1Exp = new ObjectExp(new Integer(1));
		ObjectExp toExp = new ObjectExp(new Integer(10));
		BoolExpression exp = new NotBetweenExp(arg1Exp, NullExp.NULL, toExp);
		assertEquals("1", false, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(NotBetweenExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { NotBetweenExpTest.class.getName()});
	}
}