package test.org.seasar.framework.sel.boolexps;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.boolexps.LikeExp;
import org.seasar.framework.sel.exps.ObjectExp;

public class LikeExpTest extends TestCase {

	public LikeExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		Expression arg1Exp = new ObjectExp("SCOTT");
		BoolExpression exp = new LikeExp(arg1Exp, arg1Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	public void testEvaluate2() throws Exception {
		Expression arg1Exp = new ObjectExp("SCOTT");
		Expression arg2Exp = new ObjectExp("_COT_");
		BoolExpression exp = new LikeExp(arg1Exp, arg2Exp);
		assertEquals("1", true, exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(LikeExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { LikeExpTest.class.getName()});
	}
}