package test.org.seasar.framework.reflect;

import org.seasar.framework.reflect.ClassUtil;

import junit.framework.TestCase;

/**
 * @author higa
 *
 */
public class ClassUtilTest extends TestCase {

	/**
	 * Constructor for ClassUtilTest.
	 * @param arg0
	 */
	public ClassUtilTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ClassUtilTest.class);
	}

	public void testGetPrimitiveClass() {
		assertEquals(
			"1",
			int.class,
			ClassUtil.getPrimitiveClass(Integer.class));
		assertEquals("2", null, ClassUtil.getPrimitiveClass(String.class));
	}

	public void testGetPrimitiveClassIfWrapper() {
		assertEquals(
			"1",
			int.class,
			ClassUtil.getPrimitiveClassIfWrapper(Integer.class));
		assertEquals(
			"2",
			String.class,
			ClassUtil.getPrimitiveClassIfWrapper(String.class));
	}
	
	public void testIsAssignableFrom() {
		assertEquals(
			"1",
			true,
			ClassUtil.isAssignableFrom(Number.class, Integer.class));
		assertEquals(
			"2",
			false,
			ClassUtil.isAssignableFrom(Integer.class, Number.class));
		assertEquals(
			"3",
			true,
			ClassUtil.isAssignableFrom(int.class, Integer.class));
	}
}
