package test.org.seasar.framework.collection;

import java.util.HashMap;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.collection.CaseInsensitiveMap;

public class CaseInsensitiveMapTest extends TestCase {

	private CaseInsensitiveMap _map;

	public CaseInsensitiveMapTest(String name) {
		super(name);
	}

	public void testContainsKey() throws Exception {
		assertTrue("1", _map.containsKey("ONE"));
		assertTrue("2", _map.containsKey("one"));
		assertTrue("3", !_map.containsKey("onex"));
	}

	public void testGet() throws Exception {
		assertEquals("1", "1", _map.get("ONE"));
		assertEquals("2", "1", _map.get("One"));
		assertEquals("3", null, _map.get("hoge"));
	}

	public void testPut() throws Exception {
		assertEquals("1", "1", _map.put("One", "11"));
		assertEquals("2", "11", _map.get("one"));
	}

	public void testRemove() throws Exception {
		assertEquals("1", "1", _map.remove("ONE"));
		assertEquals("2", 1, _map.size());
		assertEquals("3", null, _map.remove("dummy"));
	}

	public void testPutAll() throws Exception {
		Map m = new HashMap();
		m.put("three", "3");
		m.put("four", "4");
		_map.putAll(m);
		assertEquals("1", "3", _map.get("THREE"));
		assertEquals("2", "4", _map.get("FOUR"));
		assertEquals("3", 4, _map.size());
	}

	public void testPerformance() throws Exception {
		for (int j = 0; j < 3; ++j) {

			int num = 100000;
			Map hmap = new HashMap();
			Map cimap = new CaseInsensitiveMap();

			long start = System.currentTimeMillis();
			for (int i = 0; i < num; i++) {
				hmap.put("a" + String.valueOf(i), null);
			}
			System.out.println(
				"HashMap.put:" + (System.currentTimeMillis() - start));

			start = System.currentTimeMillis();
			for (int i = 0; i < num; i++) {
				cimap.put("a" + String.valueOf(i), null);
			}
			System.out.println(
				"CaseInsensitiveMap.put:"
					+ (System.currentTimeMillis() - start));

			start = System.currentTimeMillis();
			for (int i = 0; i < num; i++) {
				hmap.get("a" + String.valueOf(i));
			}
			System.out.println(
				"HashMap.get:" + (System.currentTimeMillis() - start));

			start = System.currentTimeMillis();
			for (int i = 0; i < num; i++) {
				cimap.get("a" + String.valueOf(i));
			}
			System.out.println(
				"CaseInsensitiveMap.get:"
					+ (System.currentTimeMillis() - start));

		}

	}

	protected void setUp() throws Exception {
		_map = new CaseInsensitiveMap();
		_map.put("one", "1");
		_map.put("two", "2");
	}

	protected void tearDown() throws Exception {
		_map = null;
	}

	public static Test suite() {
		return new TestSuite(CaseInsensitiveMapTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { CaseInsensitiveMapTest.class.getName()});
	}
}
