package org.seasar.framework.sel.exps;

import org.seasar.framework.conversion.TimestampConversionUtil;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class ToTimestampExp implements Expression {

	private final Expression _arg1Exp;
	private final String _pattern;

	public ToTimestampExp(Expression arg1Exp, String pattern) {
		_arg1Exp = arg1Exp;
		_pattern = pattern;
	}

	public Object evaluateValue(SelContext context) {
		Object arg1 = _arg1Exp.evaluateValue(context);
		return TimestampConversionUtil.toTimestamp(arg1, _pattern);
	}
}
