package org.seasar.framework.sel.exps;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.reflect.ClassUtil;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;
import org.seasar.framework.sel.util.SelContextUtil;

public final class NewExp implements Expression {

	private Class clazz_;
	private Expression[] argExps_;

	public NewExp(Class clazz, Expression[] argExps) {
		clazz_ = clazz;
		argExps_ = argExps;
	}

	public Object evaluateValue(SelContext context) {
		if (argExps_.length == 0) {
			return ClassUtil.newInstance(clazz_);
		} else {
			Object[] args = SelContextUtil.evaluateValues(context, argExps_);
			BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz_);
			return beanDesc.newInstance(args);
		}
	}
}
