package org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class NotBetweenExp extends BetweenExp {

	public NotBetweenExp(
		Expression arg1Exp,
		Expression fromExp,
		Expression toExp) {

		super(arg1Exp, fromExp, toExp);
	}

	public final boolean evaluate(SelContext context) {
		Comparable arg1 = getArg1(context);
		Comparable from = getFrom(context);
		Comparable to = getTo(context);
		if (arg1 == null || from == null || to == null) {
			return false;
		} else {
			return arg1.compareTo(from) < 0 || arg1.compareTo(to) > 0;
		}
	}
}