package org.seasar.framework.conversion;

import java.text.SimpleDateFormat;

public final class IntegerConversionUtil {

	private IntegerConversionUtil() {
	}

	public static Integer toInteger(Object o) {
		return toInteger(o, null);
	}
	
	public static Integer toInteger(Object o, String pattern) {
		if (o == null) {
			return null;
		} else if (o instanceof Integer) {
			return (Integer) o;
		} else if (o instanceof Number) {
			return new Integer(((Number) o).intValue());
		} else if (o instanceof String) {
			return new Integer((String) o);
		} else if (o instanceof java.util.Date) {
			if (pattern != null) {
				return new Integer(new SimpleDateFormat(pattern).format(o));
			} else {
				return new Integer((int) ((java.util.Date) o).getTime());
			}
		} else {
			return new Integer(o.toString());
		}
	}
	
}
