package org.seasar.framework.conversion;

import java.text.SimpleDateFormat;

public final class DoubleConversionUtil {

	private DoubleConversionUtil() {
	}

	public static Double toDouble(Object o) {
		return toDouble(o, null);
	}
	
	public static Double toDouble(Object o, String pattern) {
		if (o == null) {
			return null;
		} else if (o instanceof Double) {
			return (Double) o;
		} else if (o instanceof Number) {
			return new Double(((Number) o).doubleValue());
		} else if (o instanceof String) {
			return Double.valueOf((String) o);
		} else if (o instanceof java.util.Date) {
			if (pattern != null) {
				return new Double(new SimpleDateFormat(pattern).format(o));
			} else {
				return new Double(((java.util.Date) o).getTime());
			}
		} else {
			return new Double(o.toString());
		}
	}
}
