package org.seasar.framework.beans;

import org.seasar.framework.exception.SRuntimeException;

/**
 * @author higa
 *
 * Ώۂ̃NXɓKp\ȃ\bhȂꍇ̎sOłB
 */
public final class MethodNotFoundRuntimeException extends SRuntimeException {

	private String methodName_;
	private Class targetClass_;

	/**
	 * @param targetClass
	 */
	public MethodNotFoundRuntimeException(String methodName, Class targetClass) {
		super("ESSR0049", new Object[]{methodName, targetClass.getName()});
		
		methodName_ = methodName;
		targetClass_ = targetClass;
	}
	
	public String getMethodName() {
		return methodName_;
	}
	
	public Class getTargetClass() {
		return targetClass_;
	}
}
