package org.seasar.framework.aop.impl;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.exception.EmptyRuntimeException;

/**
 * @author higa
 *
 */
public final class PointcutImpl implements Pointcut {

	private String[] methodNames_;

	public PointcutImpl(Class targetClass)
		throws EmptyRuntimeException {

		if (targetClass == null) {
			throw new EmptyRuntimeException("targetClass");
		}
		methodNames_ = getMethodNames(targetClass);
	}

	public PointcutImpl(String[] methodNames)
		throws EmptyRuntimeException {

		if (methodNames == null || methodNames.length == 0) {
			throw new EmptyRuntimeException("methodNames");
		}
		methodNames_ = methodNames;
	}

	public boolean isApplied(Method method) {
		for (int i = 0; i < methodNames_.length; ++i) {
			if (method.getName().equals(methodNames_[i])) {
				return true;
			}
		}
		return false;
	}
	
	public String[] getMethodNames() {
		return methodNames_;
	}

	private static String[] getMethodNames(Class targetClass) {	
		Set methodNameSet = new HashSet();
		for (Class clazz = targetClass;
			clazz != Object.class && clazz != null;
			clazz = clazz.getSuperclass()) {
			Class[] interfaces = clazz.getInterfaces();
			for (int i = 0; i < interfaces.length; ++i) {
				Method[] methods = interfaces[i].getDeclaredMethods();
				for (int j = 0; j < methods.length; j++) {
					methodNameSet.add(methods[j].getName());
				}
			}
		}
		return (String[]) methodNameSet.toArray(
			new String[methodNameSet.size()]);
	
	}
}
