package test.org.seasar.util;

import junit.framework.*;
import org.seasar.util.*;

public class LineUtilTest extends TestCase {

    public LineUtilTest(String name) {
        super(name);
    }

    public void testRemoveFirstLine() throws Exception {
        String s = "aaa" + LineUtil.LINE_SP + "bbb";
        assertEquals("1", "bbb", LineUtil.removeFirstLine(s));
    }

    public void testGetLastLine() throws Exception {
        String s = "aaa" + LineUtil.LINE_SP + "bbb";
        assertEquals("1", "bbb", LineUtil.getLastLine(s));

        String s2 = "aaa" + LineUtil.LINE_SP + "bbb" + LineUtil.LINE_SP;
        assertEquals("1", "bbb", LineUtil.getLastLine(s2));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        return new TestSuite(LineUtilTest.class);
    }



    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{LineUtilTest.class.getName()});
    }
}
