package test.org.seasar.util;

import junit.framework.*;
import java.util.*;
import org.seasar.util.*;

public class ELinkedListTest extends TestCase {

    private ELinkedList _list;

    public ELinkedListTest(String name) {
        super(name);
    }

    public void testGetFirstEntry() throws Exception {
        assertNull("1", _list.getFirstEntry());
        _list.addFirst("1");
        assertEquals("2", "1", _list.getFirstEntry().getElement());
    }

    public void testGetFirst() throws Exception {
        try {
            _list.getFirst();
            fail("1");
        } catch (NoSuchElementException ex) {
            System.out.println(ex);
        }
        _list.addFirst("1");
        assertEquals("2", "1", _list.getFirst());
    }

    public void testGetLastEntry() throws Exception {
        assertNull("1", _list.getLastEntry());
        _list.addLast("1");
        assertEquals("2", "1", _list.getLastEntry().getElement());
    }

    public void testGetLast() throws Exception {
        try {
            _list.getLast();
            fail("1");
        } catch (NoSuchElementException ex) {
            System.out.println(ex);
        }
        _list.addLast("1");
        assertEquals("2", "1", _list.getLast());
    }

    public void testRemoveFirst() throws Exception {
        _list.addLast("1");
        _list.addLast("2");
        _list.removeFirst();
        assertEquals("1", "2", _list.getFirst());
    }

    public void testRemoveLast() throws Exception {
        _list.addLast("1");
        _list.addLast("2");
        _list.removeLast();
        assertEquals("1", "1", _list.getLast());
    }

    public void testAddFirst() throws Exception {
        _list.addFirst("1");
        _list.addFirst("2");
        assertEquals("1", "2", _list.getFirst());
    }

    public void testAddLast() throws Exception {
        _list.addLast("1");
        _list.addLast("2");
        assertEquals("1", "2", _list.getLast());
    }

    public void testSize() throws Exception {
        assertEquals("1", 0, _list.size());
        _list.addLast("1");
        assertEquals("2", 1, _list.size());
        _list.removeFirst();
        assertEquals("3", 0, _list.size());
    }

    public void testIsEmpty() throws Exception {
        assertTrue("1", _list.isEmpty());
        _list.addLast("1");
        assertTrue("2", !_list.isEmpty());
    }

    public void testContaines() throws Exception {
        assertTrue("1", !_list.contains(null));
        assertTrue("2", !_list.contains("1"));
        _list.addLast("1");
        assertTrue("3", _list.contains("1"));
        assertTrue("4", !_list.contains("2"));
        assertTrue("5", !_list.contains(null));
    }

    public void testRemove() throws Exception {
        _list.addLast(null);
        _list.addLast("1");
        _list.addLast("2");
        assertTrue("1", !_list.remove("3"));
        assertTrue("2", _list.remove("1"));
        assertTrue("3", _list.remove(null));
        _list.clear();
        _list.addLast("1");
        _list.addLast("2");
        _list.addLast("3");
        _list.remove(1);
        assertEquals("1", "1", _list.get(0));
        assertEquals("2", "3", _list.get(1));

        _list.clear();
        _list.addLast("1");
        _list.addLast("2");
        _list.addLast("3");
        ELinkedList.Entry e = _list.getEntry(1);
        e.remove();
        assertEquals("3", "3", e.getNext().getElement());
    }

    public void testClear() throws Exception {
        _list.addLast(null);
        _list.addLast("1");
        _list.addLast("2");
        _list.clear();
        assertEquals("1", 0, _list.size());
        assertNull("2", _list.getFirstEntry());
        assertNull("3", _list.getLastEntry());
    }

    public void testGetEntry() throws Exception {
        _list.addLast("1");
        _list.addLast("2");
        _list.addLast("3");
        assertEquals("1", "1", _list.getEntry(0).getElement());
        assertEquals("2", "2", _list.getEntry(1).getElement());
        assertEquals("3", "3", _list.getEntry(2).getElement());
        try {
            _list.getEntry(-1);
            fail("4");
        } catch (IndexOutOfBoundsException ex) {
            System.out.println(ex);
        }
        try {
            _list.getEntry(3);
            fail("5");
        } catch (IndexOutOfBoundsException ex) {
            System.out.println(ex);
        }
    }

    public void testGet() throws Exception {
        _list.addLast("1");
        _list.addLast("2");
        _list.addLast("3");
        assertEquals("1", "1", _list.get(0));
        assertEquals("2", "2", _list.get(1));
        assertEquals("3", "3", _list.get(2));
    }

    public void testSerialize() throws Exception {
        _list.addLast("1");
        _list.addLast("2");
        _list.addLast("3");
        assertNotNull("1", Serializer.serialize(_list));
    }

    public void testSet() throws Exception {
        _list.addLast("1");
        _list.addLast("2");
        _list.addLast("3");
        _list.set(1, "4");
        assertEquals("1", "4", _list.get(1));
    }

    public void testEntry() throws Exception {
        _list.addLast("1");
        _list.addLast("2");
        _list.addLast("3");
        ELinkedList.Entry e = _list.getFirstEntry();
        assertNull("1", e.getPrevious());
        assertEquals("2", "2", e.getNext().getElement());
        e = _list.getLastEntry();
        assertNull("3", e.getNext());
        assertEquals("4", "2", e.getPrevious().getElement());
        _list.getEntry(1).remove();
        assertEquals("5", "1", _list.getFirst());
        assertEquals("6", "3", _list.getLast());
        _list.getLastEntry().remove();
        assertEquals("7", "1", _list.getLast());
        _list.getLastEntry().remove();
        assertEquals("8", 0, _list.size());
    }

    public void testAdd() throws Exception {
        _list.addLast("1");
        _list.addLast("2");
        _list.addLast("3");
        _list.add(1, "4");
        assertEquals("1", "4", _list.get(1));
        assertEquals("2", "2", _list.get(2));
    }

    public void testIndexOf() throws Exception {
        _list.addLast(null);
        _list.addLast("1");
        _list.addLast("2");
        _list.addLast("3");
        assertEquals("1", 0, _list.indexOf(null));
        assertEquals("2", 1, _list.indexOf("1"));
        assertEquals("3", 2, _list.indexOf("2"));
        assertEquals("4", 3, _list.indexOf("3"));
        assertEquals("5", -1, _list.indexOf("4"));
    }

    protected void setUp() throws Exception {
        _list = new ELinkedList();
    }

    protected void tearDown() throws Exception {
        _list.clear();
        _list = null;
    }

    public static Test suite() {
        return new TestSuite(ELinkedListTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{ELinkedListTest.class.getName()});
    }
}
